package com.elitesland.fin.provider.invoice.await;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitDConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceConvert;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDDTO;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.invoice.impl.AbstractInvoiceSaveServiceImpl;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.param.invoice.InvoiceAwaitDSaveParam;
import com.elitesland.fin.param.invoice.InvoiceAwaitSaveParam;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepo;
import com.elitesland.fin.repo.invoice.InvoiceRuleConfigRepoProc;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.service.invoice.InvoiceAwaitRpcService;
import com.elitesland.fin.service.pay.PayRpcService;
import com.elitesland.order.param.SalReconciliatQueryDTO;
import com.elitesland.order.param.SaleReconciliatDTO;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import io.seata.common.util.CollectionUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + PayRpcService.PATH)
public class InvoiceAwaitRpcServiceImpl implements InvoiceAwaitRpcService {

    private final InvoiceAwaitSaveServiceFactory invoiceAwaitSaveServiceFactory;

    private final InvoiceAwaitRepo invoiceAwaitRepo;

    private final InvoiceAwaitDRepo invoiceAwaitDRepo;

    private final SystemRpcService systemRpcService;
    private final InvoiceAwaitService invoiceAwaitService;
    private final InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc;
    private final RmiOrderRpcService rmiOrderRpcService;
    private final SysNumberGenerator sysNumberGenerator;
    private final FlexFieldUtilService flexFieldUtilService;
    @Autowired
    private AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> save(InvoiceAwaitSaveParam param) {
        log.info("开始组装待开票数据，接收到的参数为{}", JSON.toJSONString(param));
        ApiResult<Long> result = checkSaveParam(param);
        if (ObjectUtil.isNotNull(result)) {
            log.info("组装待开票数据参数校验失败，返回结果为{}", JSON.toJSONString(result));
            return result;
        }
        // 根据开票设置，如果配置了销售对账单生成代开开票，则查询对账单并生成代开发票单据
        InvoiceRuleConfigQueryParam ruleConfigQueryParam = new InvoiceRuleConfigQueryParam();
        ruleConfigQueryParam.setOptDocCls(param.getOptDocCls());
        List<InvoiceRuleConfigDTO> ruleConfigDTOList = invoiceRuleConfigRepoProc.getListByParam(ruleConfigQueryParam);
        if (CollectionUtil.isEmpty(ruleConfigDTOList)) {
            log.info("未配置开票设置，无需生成代开发票");
            return null;
        }

        // 1.获取付款单
        SalReconciliatQueryDTO dto = new SalReconciliatQueryDTO();
        dto.setDocNos(new ArrayList<>() {{
            add(param.getOptDocNo());
        }});
//        dto.setInvState(UdcEnum.INV_STATE_WAIT.getValueCode());
        dto.setState("PASS");

        List<SaleReconciliatDTO> saleReconciliatDTOS;
        try {
            log.info("查询对账单参数：{}", dto);
            saleReconciliatDTOS = rmiOrderRpcService.querySalReconciliat(dto);
            log.info("对账单查询到的数据结果：{} ", JSONUtil.toJsonStr(saleReconciliatDTOS));
        } catch (Exception e) {
            log.error("调用对账单接口出错,请求参数:{}, 报错信息：{}  ", dto, e.getMessage());
            return null;
        }

        if (CollectionUtil.isEmpty(saleReconciliatDTOS)) {
            return null;
        }
        // 过滤没有明细的数据
        List<SaleReconciliatDTO> collect = saleReconciliatDTOS.stream().filter(item -> CollectionUtil.isNotEmpty(item.getSaleReconciliatDtlDTOList())).toList();
        // 数据转换
        List<InvoiceAwaitDTO> dtos = invoiceAwaitService.buildSalRecToInvoiceAwaitOrder(collect);

        List<Long> list = new ArrayList<>();
        // 保存数据
        log.info("保存待开票申请：{}", JSONUtil.toJsonStr(dtos));
        List<InvoiceAwaitDO> invoiceAwaitDOList = new ArrayList<>();
        dtos.forEach(item -> {
            String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_DKFP_NO.getCode());
            InvoiceAwaitDO awaitDO = InvoiceConvert.INSTANCE.dto2Do(item);
            awaitDO.setDocNo(docNo);
            flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.INVOICE_AWAIT, awaitDO);
            InvoiceAwaitDO save = invoiceAwaitRepo.save(awaitDO);
            List<InvoiceAwaitDDTO> dtlList = item.getInvoiceAwaitDDTOList();
            dtlList.forEach(dtl -> {
                InvoiceAwaitDDO dtlDo = InvoiceAwaitDConvert.INSTANCE.dto2Do(dtl);
                dtlDo.setMasId(save.getId());
                invoiceAwaitDRepo.save(dtlDo);
                list.add(dtl.getOptDocDtlId());
            });
            invoiceAwaitDOList.add(save);
        });

        // 更新对账单明细表传输状态
        List<Long> collect2 = list.stream().filter(ObjectUtil::isNotNull).toList();
        if (CollectionUtils.isNotEmpty(collect2)) {
            SalReconciliatQueryDTO updateDto = new SalReconciliatQueryDTO();
            updateDto.setDtlIds(list);
            try {
                rmiOrderRpcService.updateTransState(updateDto);
            } catch (Exception e) {
                log.error("更新对账单明细传输状态失败，参数: {}，失败信息: {}，", updateDto, e.getMessage());
            }
        }

        // 生成开票
        invoiceAwaitDOList.forEach(save -> {
            InvoiceApplyParam applyParam = invoiceAwaitService.getInvoiceApplyParamByAwaitOrder(save);
            log.info("生成待开票申请：{}", JSONUtil.toJsonStr(applyParam));
            abstractInvoiceSaveService.save(applyParam);
        });

        return ApiResult.ok();
    }

    private ApiResult<Long> checkSaveParam(InvoiceAwaitSaveParam param) {
        if (Strings.isEmpty(param.getOptDocType())) {
            return ApiResult.fail("来源单据类型不能为空");
        }

        if (Strings.isEmpty(param.getOptDocNo())) {
            return ApiResult.fail("来源单据编号不能为空");
        }
        if (Strings.isEmpty(param.getOptDocStatus())) {
            return ApiResult.fail("可开票状态不能为空");
        }

        if (invoiceAwaitRepo.existsByOptDocNoAndOptDocType(param.getOptDocNo(), param.getOptDocType())) {
            return ApiResult.fail("来源单据已经申请开过发票");
        }

        return null;
    }


    public Long saveInvoiceAwait(InvoiceAwaitSaveParam param) {

        InvoiceAwaitDO invoiceAwaitDO = InvoiceAwaitConvert.INSTANCE.saveParam2Do(param);
        // 通过发号器设置付款记录编号
        invoiceAwaitDO.setDocNo(systemRpcService.sysNumberRuleGenerateCode("yst-fin", "PAYMENT_RECORDS", new ArrayList<>()));
        // 来源单据：收货单
        Long masId = invoiceAwaitRepo.save(invoiceAwaitDO).getId();

        this.saveRecordsD(param, masId);

        return masId;
    }

    protected void saveRecordsD(InvoiceAwaitSaveParam saveVO, Long masId) {
        List<InvoiceAwaitDSaveParam> invoiceAwaitDSaveParamList = saveVO.getInvoiceAwaitDSaveParamList();
        List<InvoiceAwaitDDO> invoiceAwaitDDOS = InvoiceAwaitDConvert.INSTANCE.saveVOs2DOs(invoiceAwaitDSaveParamList);
        AtomicInteger lineNo = new AtomicInteger();
        invoiceAwaitDDOS.stream().forEach(ddo -> {
            ddo.setMasId(masId);
            ddo.setLineNo(lineNo.getAndIncrement());
        });
        // 删除旧的明细
        invoiceAwaitDRepo.deleteByMasId(masId);
        invoiceAwaitDRepo.saveAll(invoiceAwaitDDOS);
    }

    /**
     * 根据来源单号批量逻辑删除
     *
     * @param optDocNos 来源单号
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByOptDocNoBatch(List<String> optDocNos){
        log.info("根据来源单号批量逻辑删除的Rpc入参：{}" + JSON.toJSONString(optDocNos));

        if (CollectionUtil.isNotEmpty(optDocNos)){
            invoiceAwaitService.updateDeleteFlagByOptDocNoBatch(optDocNos);
        }
    }

    /**
     * 根据来源单据主键id批量逻辑删除
     *
     * @param optDocIds 来源单据主键id
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByOptDocIdBatch(List<Long> optDocIds){
        log.info("根据来源单据主键id批量逻辑删除的Rpc入参：{}" + JSON.toJSONString(optDocIds));

        if (CollectionUtil.isNotEmpty(optDocIds)){
            invoiceAwaitService.updateDeleteFlagByOptDocIdBatch(optDocIds);
        }
    }

}
