/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitesland.fin.application.convert.arorder.ArOrderExConvert;
import com.elitesland.fin.application.facade.dto.writeoff.ArOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.dto.writeoff.ArOrderExDTO;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlExPageParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderExPageParam;
import com.elitesland.fin.application.facade.param.arorder.FinArOrderDetailQuery;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderExVo;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.service.arorder.ArOrderExService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOderExDtlDo;
import com.elitesland.fin.domain.entity.arorder.QArOderExDtlDo;
import com.elitesland.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.fin.domain.entity.arorder.QArOrderExDo;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.repo.writeoff.ArOrderDetailRepoProc;
import com.elitesland.fin.repo.writeoff.ArOrderExRepoProc;
import com.elitesland.fin.utils.BeanConvertUtils;
import com.elitesland.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.dto.CrmCustDTO;
import com.elitesland.sale.service.CrmCustRpcService;
import com.elitesland.support.provider.item.dto.ItmItemDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ArOrderExServiceImpl
extends BaseServiceImpl
implements ArOrderExService {
    private static final Logger log = LogManager.getLogger(ArOrderExServiceImpl.class);
    final QArOrderExDo arOrderExDo = QArOrderExDo.arOrderExDo;
    final QArOderExDtlDo qArOderExDtlDo = QArOderExDtlDo.arOderExDtlDo;
    final QArOrderDO qArOrderDO = QArOrderDO.arOrderDO;
    final JPAQueryFactory jpaQueryFactory;
    final CrmCustRpcService crmCustRpcService;
    final OrgRpcService orgRpcService;
    final SysCurrencyRpcService sysCurrencyRpcService;
    final ArOrderDetailRepoProc arOrderDetailRepoProc;
    final EmployeeRpcService employeeRpcService;
    final ArOrderExRepoProc arOrderExRepoProc;
    final ArOrderDomainService arOrderDomainService;

    @Override
    @SysCodeProc
    public PagingVO<ArOrderExVo> page(ArOrderExPageParam param) {
        Integer size = param.size;
        Integer current = param.current;
        param.size = Integer.MAX_VALUE;
        param.current = 1;
        PagingVO<ArOrderExVo> page = this.arOrderExRepoProc.page(param);
        if (page.isEmpty()) {
            return page;
        }
        this.setInfo(page);
        if (Boolean.TRUE.equals(param.getHeadFlag())) {
            List records = page.getRecords();
            if (CollectionUtils.isEmpty(records = records.stream().filter(item -> BigDecimal.ZERO.compareTo(item.getUnVerAmt()) != 0).collect(Collectors.toList()))) {
                return PagingVO.empty();
            }
            param.size = size;
            param.current = current;
            param.setIds(records.stream().map(ArOrderVO::getId).collect(Collectors.toList()));
            page = this.arOrderExRepoProc.page(param);
            this.setInfo(page);
        }
        return page;
    }

    @Override
    @SysCodeProc
    public PagingVO<ArOrderDtlExVo> detailPage(ArOrderDtlExPageParam param) {
        PagingVO<ArOrderDtlExVo> page = this.arOrderExRepoProc.detailPage(param);
        if (page.isEmpty()) {
            return page;
        }
        this.setDetailInfo(page.getRecords());
        return page;
    }

    private void setDetailInfo(List<ArOrderDtlExVo> records) {
        HashSet<String> itemCodes = new HashSet<String>();
        HashSet<String> buCodes = new HashSet<String>();
        HashSet<String> custCodes = new HashSet<String>();
        HashSet<String> saleUserCodes = new HashSet<String>();
        this.setDetailCode(records, itemCodes, buCodes, custCodes, saleUserCodes);
        List<SysOrgBasicDTO> orgList = this.getOrgList(buCodes);
        Map<Object, Object> orgMap = new HashMap();
        if (CollUtil.isNotEmpty(orgList)) {
            orgMap = orgList.stream().collect(Collectors.toMap(k -> k.getCode(), v -> v.getName(), (v1, v2) -> v2));
        }
        List<LmSaveCustRespVO> custResult = this.getCustList(custCodes);
        Map<Object, Object> custMap = new HashMap();
        if (CollUtil.isNotEmpty(orgList)) {
            custMap = custResult.stream().collect(Collectors.toMap(k -> k.getCustCode(), v -> v.getCustName(), (v1, v2) -> v2));
        }
        List<SysEmployeeBasicDTO> employeeList = this.getEmployeeList(saleUserCodes);
        Map<Object, Object> empMap = new HashMap();
        if (CollUtil.isNotEmpty(orgList)) {
            empMap = employeeList.stream().collect(Collectors.toMap(k -> k.getCode(), v -> v.getLastName(), (v1, v2) -> v2));
        }
        List<ItmItemDTO> itemList = this.getItemDtoByItemCodes(itemCodes);
        Map<Object, Object> finalOrgMap = orgMap;
        Map<Object, Object> finalCustMap = custMap;
        Map<Object, Object> finalEmpMap = empMap;
        records.forEach(arOrderExVo -> {
            arOrderExVo.setArOrderType("\u5e94\u6536\u5355");
            if (StrUtil.isEmpty((CharSequence)arOrderExVo.getOrderNo())) {
                arOrderExVo.setOrderNo(arOrderExVo.getSalSoDocNo());
            }
            if (!CollectionUtils.isEmpty((Collection)itemList)) {
                itemList.stream().filter(fi -> fi.getItemCode().equals(arOrderExVo.getItemCode())).findFirst().ifPresent(opt -> {
                    arOrderExVo.setItemName(opt.getItemName());
                    arOrderExVo.setItemSpec(opt.getSpec());
                });
            }
            if (StrUtil.isEmpty((CharSequence)arOrderExVo.getOuName()) && finalOrgMap.containsKey(arOrderExVo.getOuCode())) {
                arOrderExVo.setOuName((String)finalOrgMap.get(arOrderExVo.getOuCode()));
            }
            if (StrUtil.isEmpty((CharSequence)arOrderExVo.getBuName()) && finalOrgMap.containsKey(arOrderExVo.getMasBuCode())) {
                arOrderExVo.setBuCode(arOrderExVo.getMasBuCode());
                arOrderExVo.setBuName((String)finalOrgMap.get(arOrderExVo.getMasBuCode()));
            }
            if (finalCustMap.containsKey(arOrderExVo.getCustCode())) {
                arOrderExVo.setCustomName((String)finalCustMap.get(arOrderExVo.getCustCode()));
            }
            if (StrUtil.isEmpty((CharSequence)arOrderExVo.getBusinessName()) && finalEmpMap.containsKey(arOrderExVo.getBusinessCode())) {
                arOrderExVo.setBusinessName((String)finalEmpMap.get(arOrderExVo.getBusinessCode()));
            }
        });
    }

    private List<ItmItemDTO> getItemDtoByItemCodes(Set<String> itemCodes) {
        if (itemCodes.isEmpty()) {
            return Collections.emptyList();
        }
        return null;
    }

    private void setDetailCode(List<ArOrderDtlExVo> records, Set<String> itemCodes, Set<String> buCodes, Set<String> custCodes, Set<String> saleUserCodes) {
        for (ArOrderDtlExVo vo : records) {
            itemCodes.add(vo.getItemCode());
            buCodes.add(vo.getOuCode());
            buCodes.add(vo.getBuCode());
            buCodes.add(vo.getMasBuCode());
            custCodes.add(vo.getCustCode());
            saleUserCodes.add(vo.getSaleUser());
        }
    }

    private void setInfo(PagingVO<ArOrderExVo> page) {
        HashSet<String> buCodes = new HashSet<String>(8);
        HashSet<String> custCodes = new HashSet<String>(8);
        HashSet<String> currCodes = new HashSet<String>(8);
        HashSet<String> saleUserCodes = new HashSet<String>(8);
        HashSet<Long> masIds = new HashSet<Long>(8);
        this.setCode(page, buCodes, custCodes, currCodes, saleUserCodes, masIds);
        List<ArOderExDtlDo> arOderExDtlDo = this.arOrderDetailRepoProc.listByMasIds(masIds);
        List<SysOrgBasicDTO> orgList = this.getOrgList(buCodes);
        List<LmSaveCustRespVO> custResult = this.getCustList(custCodes);
        List<SysCurrencyRespDTO> currList = this.getCurrList(currCodes);
        List<SysEmployeeBasicDTO> employeeList = this.getEmployeeList(saleUserCodes);
        page.getRecords().forEach(arOrderExVo -> {
            arOrderExVo.setArTypeName("\u5e94\u6536\u5355");
            if (!CollectionUtils.isEmpty((Collection)orgList)) {
                orgList.stream().filter(fi -> fi.getCode().equals(arOrderExVo.getBuCode())).findFirst().ifPresent(opt -> arOrderExVo.setBuName(opt.getName()));
                orgList.stream().filter(fi -> fi.getCode().equals(arOrderExVo.getOuCode())).findFirst().ifPresent(opt -> arOrderExVo.setOuName(opt.getName()));
            }
            if (!CollectionUtils.isEmpty((Collection)custResult)) {
                custResult.stream().filter(fi -> fi.getCustCode().equals(arOrderExVo.getCustCode())).findFirst().ifPresent(opt -> arOrderExVo.setCustomName(opt.getCustName()));
            }
            if (!CollectionUtils.isEmpty((Collection)currList)) {
                currList.stream().filter(fi -> fi.getCurrCode().equals(arOrderExVo.getCurrCode())).findFirst().ifPresent(opt -> arOrderExVo.setCurrName(opt.getCurrName()));
            }
            if (!CollectionUtils.isEmpty((Collection)employeeList)) {
                employeeList.stream().filter(fi -> fi.getCode().equals(arOrderExVo.getSaleUser())).findFirst().ifPresent(opt -> arOrderExVo.setBusinessName(opt.getLastName()));
            }
            BigDecimal verAmt = BigDecimal.ZERO;
            BigDecimal verAmting = BigDecimal.ZERO;
            BigDecimal unVerAmt = BigDecimal.ZERO;
            List extDList = arOderExDtlDo.stream().filter(fi -> fi.getMasId().equals(arOrderExVo.getExtId())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(extDList)) {
                for (ArOderExDtlDo arOderExDtlDo1 : extDList) {
                    verAmt = verAmt.add(arOderExDtlDo1.getVerAmt());
                    verAmting = verAmting.add(arOderExDtlDo1.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(arOderExDtlDo1.getUnVerAmt());
                }
            }
            arOrderExVo.setVerAmt(verAmt);
            arOrderExVo.setApplyVerAmTing(verAmting);
            arOrderExVo.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(arOrderExVo.getTotalAmt()) == 0) {
                arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }
        });
    }

    private List<SysCurrencyRespDTO> getCurrList(Set<String> currCodes) {
        ApiResult currResult = this.sysCurrencyRpcService.listByCodes(currCodes);
        if (currResult.isFailed()) {
            throw new BusinessException("\u83b7\u53d6\u5e01\u79cd\u4fe1\u606f\u5931\u8d25");
        }
        return (List)currResult.getData();
    }

    private List<SysEmployeeBasicDTO> getEmployeeList(Set<String> saleUserCodes) {
        EmployeeQueryDTO eeQuery = new EmployeeQueryDTO();
        eeQuery.setCodes(saleUserCodes);
        ApiResult eeResult = this.employeeRpcService.queryList(eeQuery);
        if (eeResult.isFailed()) {
            throw new BusinessException("\u83b7\u53d6\u4e1a\u52a1\u5458\u4fe1\u606f\u5931\u8d25");
        }
        return (List)eeResult.getData();
    }

    private List<LmSaveCustRespVO> getCustList(Set<String> custCodes) {
        CustCode2BaseParam custQuery = new CustCode2BaseParam();
        custQuery.setCustCode(new ArrayList<String>(custCodes));
        return this.crmCustRpcService.findBaseCustInfo(custQuery);
    }

    private List<SysOrgBasicDTO> getOrgList(Set<String> buCodes) {
        SysOrgQueryDTO orgQuery = new SysOrgQueryDTO();
        orgQuery.setCodes(buCodes);
        ApiResult orgResult = this.orgRpcService.queryList(orgQuery);
        if (orgResult.isFailed()) {
            throw new BusinessException("\u83b7\u53d6\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
        }
        return (List)orgResult.getData();
    }

    private void setCode(PagingVO<ArOrderExVo> page, Set<String> buCodes, Set<String> custCodes, Set<String> currCodes, Set<String> saleUserCodes, Set<Long> masIds) {
        for (ArOrderExVo vo : page.getRecords()) {
            buCodes.add(vo.getOuCode());
            buCodes.add(vo.getBuCode());
            custCodes.add(vo.getCustCode());
            currCodes.add(vo.getCurrCode());
            saleUserCodes.add(vo.getSaleUser());
            masIds.add(vo.getExtId());
        }
    }

    @Override
    @SysCodeProc
    public ArOrderExVo getDetailExInfo(ArOrderVO res) {
        List list = ((JPAQuery)this.select(ArOrderExDTO.class).where((Predicate)this.arOrderExDo.relateId.eq((Object)res.getRelateId()))).fetch();
        ArOrderExVo arOrderExVo = new ArOrderExVo();
        if (CollUtil.isNotEmpty((Collection)list)) {
            ArOrderExDTO arOrderExDTO = (ArOrderExDTO)list.get(0);
            ArOrderExVo arOrderExVo1 = ArOrderExConvert.INSTANCE.qeryDto2Vo(arOrderExDTO);
            ArOrderExVo arOrderExVo2 = ArOrderExConvert.INSTANCE.Vo2ExVo(res);
            arOrderExVo = (ArOrderExVo)BeanConvertUtils.beanConvert(arOrderExVo1, arOrderExVo2);
            try {
                SysOrgBasicDTO data = (SysOrgBasicDTO)this.orgRpcService.getByCode(arOrderExVo.getBuCode()).getData();
                arOrderExVo.setBuName(data == null ? "" : data.getName());
                CrmCustDTO data1 = (CrmCustDTO)this.crmCustRpcService.getCustInfo(arOrderExVo.getCustCode()).getData();
                arOrderExVo.setCustomName(data1 == null ? "" : data1.getCustName());
                SysOrgBasicDTO data2 = (SysOrgBasicDTO)this.orgRpcService.getByCode(arOrderExVo.getOuCode()).getData();
                arOrderExVo.setOuName(data2 == null ? "" : data2.getName());
                SysCurrencyRespDTO data3 = (SysCurrencyRespDTO)this.sysCurrencyRpcService.getByCode(arOrderExVo.getCurrCode()).getData();
                arOrderExVo.setCurrName(data3 == null ? "" : data3.getCurrName());
                SysEmployeeBasicDTO data4 = (SysEmployeeBasicDTO)this.employeeRpcService.getByCode(arOrderExVo.getSaleUser()).getData();
                arOrderExVo.setBusinessName(data4 == null ? "" : data4.getLastName());
                arOrderExVo.setArTypeName("\u5e94\u6536\u5355");
                List<Long> masIds = Arrays.asList(arOrderExDTO.getId());
                List<ArOderExDtlDo> arOderExDtlDo = this.arOrderDetailRepoProc.listByMasIds(masIds);
                List extDList = arOderExDtlDo.stream().filter(fi -> fi.getMasId().equals(arOrderExDTO.getId())).collect(Collectors.toList());
                BigDecimal verAmt = BigDecimal.ZERO;
                BigDecimal verAmting = BigDecimal.ZERO;
                BigDecimal unVerAmt = BigDecimal.ZERO;
                if (CollUtil.isNotEmpty(extDList)) {
                    for (ArOderExDtlDo arOderExDtlDo1 : extDList) {
                        verAmt = verAmt.add(arOderExDtlDo1.getVerAmt());
                        verAmting = verAmting.add(arOderExDtlDo1.getApplyVerAmTing());
                        unVerAmt = unVerAmt.add(arOderExDtlDo1.getUnVerAmt());
                    }
                }
                arOrderExVo.setVerAmt(verAmt);
                arOrderExVo.setApplyVerAmTing(verAmting);
                arOrderExVo.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(arOrderExVo.getTotalAmt()) == 0) {
                    arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    arOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return arOrderExVo;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.arOrderExDo.id, this.arOrderExDo.orderCustomer, this.arOrderExDo.invoiceNumber, this.arOrderExDo.invDate, this.arOrderExDo.relateId, this.arOrderExDo.invType, this.arOrderExDo.startDate, this.arOrderExDo.redFlushSign, this.arOrderExDo.thirdPaymentAssistance, this.arOrderExDo.consumerCardSsistance, this.arOrderExDo.creditCardAssistance, this.arOrderExDo.deleteFlag, this.arOrderExDo.tenantId, this.arOrderExDo.belongOrgId, this.arOrderExDo.tenantOrgId, this.arOrderExDo.createTime, this.arOrderExDo.updater, this.arOrderExDo.modifyTime, this.arOrderExDo.creator, this.arOrderExDo.remark, this.qArOrderDO.custCode, this.qArOrderDO.sourceNo})).from((EntityPath)this.arOrderExDo)).leftJoin((EntityPath)this.qArOderExDtlDo)).on((Predicate)this.qArOderExDtlDo.masId.eq(this.arOrderExDo.id));
    }

    @Override
    public List<ArOrderDtlExVo> listArOrderDetail(FinArOrderDetailQuery query) {
        return this.arOrderDetailRepoProc.listArOrderDetail(query);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long arDId, BigDecimal amt, String verType) {
        ArOderExDtlDo detail = this.findDetail(arDId);
        this.doUpdateVerAmt(this.getUpdateVerAmtBuilder(amt, detail, verType).build());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMiddleVerAmt(Long arDId, BigDecimal amt) {
        ArOderExDtlDo detail = this.findDetail(arDId);
        this.doUpdateVerAmt(this.getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }

    @Override
    public ApiResult<ArOrderExVo> info(Long id) {
        ArOrderDTO arOrderDTO = this.arOrderDomainService.get(id);
        return null;
    }

    private ArOrderAmtUpdateDTO.ArOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, ArOderExDtlDo detail) {
        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);
        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return ArOrderAmtUpdateDTO.builder().arDId(detail.getExtId()).unVerAmt(unVerAmt).verAmting(verAmting).verAmt(detail.getVerAmt()).version(detail.getVersion());
    }

    @NotNull
    private ArOrderAmtUpdateDTO.ArOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, ArOderExDtlDo detail, String verType) {
        String infoStr = JSONUtil.toJsonStr((Object)detail);
        log.info("\u8ba1\u7b97\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d,{}-{}", (Object)amt, (Object)infoStr);
        BigDecimal verAmt = detail.getVerAmt().subtract(amt);
        BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
        log.info("\u53d6\u6d88\u6838\u9500,{}-{}-{}", (Object)infoStr, (Object)verAmt, (Object)unVerAmt);
        if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return ArOrderAmtUpdateDTO.builder().arDId(detail.getExtId()).unVerAmt(unVerAmt).verAmting(detail.getApplyVerAmTing()).verAmt(verAmt).version(detail.getVersion());
    }

    @NotNull
    private ArOderExDtlDo findDetail(Long arDId) {
        ArOderExDtlDo detail = this.arOrderDetailRepoProc.getArOrderDetailAmt(arDId);
        log.error("\u672a\u67e5\u8be2\u5230\u5e94\u6536\u5355\u660e\u7ec6\u884c\uff0c\u660e\u7ec6ID:" + arDId);
        Assert.notNull((Object)detail, (String)"\u672a\u67e5\u8be2\u5230\u5e94\u6536\u5355\u660e\u7ec6\u884c");
        return detail;
    }

    private void doUpdateVerAmt(ArOrderAmtUpdateDTO update) {
        if (this.arOrderDetailRepoProc.updateVerAmt(update) == 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    public ArOrderExServiceImpl(JPAQueryFactory jpaQueryFactory, CrmCustRpcService crmCustRpcService, OrgRpcService orgRpcService, SysCurrencyRpcService sysCurrencyRpcService, ArOrderDetailRepoProc arOrderDetailRepoProc, EmployeeRpcService employeeRpcService, ArOrderExRepoProc arOrderExRepoProc, ArOrderDomainService arOrderDomainService) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.crmCustRpcService = crmCustRpcService;
        this.orgRpcService = orgRpcService;
        this.sysCurrencyRpcService = sysCurrencyRpcService;
        this.arOrderDetailRepoProc = arOrderDetailRepoProc;
        this.employeeRpcService = employeeRpcService;
        this.arOrderExRepoProc = arOrderExRepoProc;
        this.arOrderDomainService = arOrderDomainService;
    }
}

