/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.creditaccount;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountIocConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountIocDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountIocParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocParamVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocRespVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocSaveVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountIocService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.creditaccount.CreditAccountIocDomainService;
import com.elitesland.fin.entity.creditaccount.CreditAccountIoc;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CreditAccountIocServiceImpl
implements CreditAccountIocService {
    private static final Logger log = LoggerFactory.getLogger(CreditAccountIocServiceImpl.class);
    private final CreditAccountIocDomainService creditAccountIocDomainService;
    private final RedisUtils redisUtils;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> createOne(CreditAccountIocSaveVO saveVo) {
        CreditAccountIoc accountIoc = CreditAccountIocConvert.INSTANCE.saveVoToEn(saveVo);
        if (StringUtils.isEmpty((CharSequence)accountIoc.getStatus())) {
            accountIoc.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        }
        this.checkIocMandatory(accountIoc);
        this.checkIocCodeAndName(accountIoc);
        Long id = this.creditAccountIocDomainService.saveAccountIoc(accountIoc, Optional.empty());
        this.redisUtils.del(new String[]{"YST_FIN_CREDIT_ACCOUNT_IOC"});
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(CreditAccountIocSaveVO saveVo) {
        Optional<CreditAccountIocDTO> iocDTOOptional = this.creditAccountIocDomainService.findById(saveVo.getId());
        if (iocDTOOptional.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4e8b\u52a1\u7801\u4fe1\u606f!");
        }
        CreditAccountIoc accountIoc = CreditAccountIocConvert.INSTANCE.saveVoToEn(saveVo);
        this.checkIocMandatory(accountIoc);
        this.checkIocCodeAndName(accountIoc);
        Long id = this.creditAccountIocDomainService.saveAccountIoc(accountIoc, iocDTOOptional);
        this.redisUtils.del(new String[]{"YST_FIN_CREDIT_ACCOUNT_IOC"});
        return ApiResult.ok((Object)id);
    }

    private void checkIocMandatory(CreditAccountIoc accountIoc) {
        if (StringUtils.isEmpty((CharSequence)accountIoc.getIoCode())) {
            throw new BusinessException(ApiCode.FAIL, "\u4e8b\u52a1\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)accountIoc.getIoName())) {
            throw new BusinessException(ApiCode.FAIL, "\u4e8b\u52a1\u7801\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)accountIoc.getIoTypeName())) {
            throw new BusinessException(ApiCode.FAIL, "\u4e8b\u52a1\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)accountIoc.getIoType())) {
            throw new BusinessException(ApiCode.FAIL, "\u4e8b\u52a1\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)accountIoc.getStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u662f\u5426\u542f\u7528\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private void checkIocCodeAndName(CreditAccountIoc accountIoc) {
        HashSet<String> ioCodeSet = new HashSet<String>();
        ioCodeSet.add(accountIoc.getIoCode());
        CreditAccountIocParam accountIocParam = new CreditAccountIocParam();
        accountIocParam.setIoCodeSet(ioCodeSet);
        List<CreditAccountIocDTO> accountIocDTOList = this.creditAccountIocDomainService.queryByAccountIocParam(accountIocParam);
        CreditAccountIocDTO accountIocDTO = accountIocDTOList.stream().filter(dto -> StringUtils.equals((CharSequence)accountIoc.getIoCode(), (CharSequence)dto.getIoCode())).findFirst().orElse(null);
        if (accountIocDTO != null) {
            Assert.equals((Object)accountIoc.getId(), (Object)accountIocDTO.getId(), (String)"\u8d26\u6237\u4e8b\u52a1\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        HashSet<String> ioNameSet = new HashSet<String>();
        ioNameSet.add(accountIoc.getIoName());
        accountIocParam = new CreditAccountIocParam();
        accountIocParam.setIoNameSet(ioNameSet);
        List<CreditAccountIocDTO> accountIocNameList = this.creditAccountIocDomainService.queryByAccountIocParam(accountIocParam);
        accountIocDTO = accountIocNameList.stream().filter(dto -> StringUtils.equals((CharSequence)accountIoc.getIoName(), (CharSequence)dto.getIoName())).findFirst().orElse(null);
        if (accountIocDTO != null) {
            Assert.equals((Object)accountIoc.getId(), (Object)accountIocDTO.getId(), (String)"\u4e8b\u52a1\u7801\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    @Override
    @SysCodeProc
    public ApiResult<CreditAccountIocRespVO> findIdOne(Long id) {
        Optional<CreditAccountIocDTO> accountIocDTOOptional = this.creditAccountIocDomainService.findById(id);
        if (accountIocDTOOptional.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4e8b\u52a1\u7801\u4fe1\u606f!");
        }
        CreditAccountIocDTO accountIocDTO = accountIocDTOOptional.get();
        CreditAccountIocRespVO accountIocRespVO = CreditAccountIocConvert.INSTANCE.dtoToRespVo(accountIocDTO);
        return ApiResult.ok((Object)accountIocRespVO);
    }

    @Override
    @SysCodeProc
    public Optional<CreditAccountIocRespVO> findByCode(String code) {
        Optional<CreditAccountIocDTO> accountDTOOptional = this.creditAccountIocDomainService.findByCode(code);
        if (accountDTOOptional.isEmpty()) {
            return Optional.empty();
        }
        CreditAccountIocDTO accountIocDTO = accountDTOOptional.get();
        CreditAccountIocRespVO accountIocRespVO = CreditAccountIocConvert.INSTANCE.dtoToRespVo(accountIocDTO);
        return Optional.of(accountIocRespVO);
    }

    @Override
    @SysCodeProc
    public List<CreditAccountIocRespVO> findByCodeBatch(List<String> codeList) {
        List<CreditAccountIocDTO> accountIocDTOList = this.creditAccountIocDomainService.findByCodeBatch(codeList);
        if (CollectionUtils.isEmpty(accountIocDTOList)) {
            return Collections.EMPTY_LIST;
        }
        List<CreditAccountIocRespVO> accountIocRespVOList = accountIocDTOList.stream().map(CreditAccountIocConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return accountIocRespVOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<CreditAccountIocRespVO> search(CreditAccountIocParamVO param) {
        PagingVO<CreditAccountIocDTO> pagingVo = this.creditAccountIocDomainService.search(param);
        if (CollectionUtils.isEmpty((Collection)pagingVo.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List vos = pagingVo.getRecords();
        List whAreaSettingRespVOList = vos.stream().map(CreditAccountIocConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVo.getTotal()).records(whAreaSettingRespVOList).build();
    }

    @Override
    @SysCodeProc
    public List<CreditAccountIocRespVO> select(CreditAccountIocParamVO param) {
        List<CreditAccountIocDTO> accountIocDTOList = this.creditAccountIocDomainService.selectByParam(param);
        if (CollectionUtils.isEmpty(accountIocDTOList)) {
            return Collections.EMPTY_LIST;
        }
        List<CreditAccountIocRespVO> accountIocRespVOList = accountIocDTOList.stream().map(CreditAccountIocConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return accountIocRespVOList;
    }

    @Override
    public List<CreditAccountIocDTO> queryByAccountIocParam(CreditAccountIocParam accountIocParam) {
        return this.creditAccountIocDomainService.queryByAccountIocParam(accountIocParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> deleteBatch(List<Long> ids) {
        this.creditAccountIocDomainService.updateDeleteFlagByIds(1, ids);
        this.redisUtils.del(new String[]{"YST_FIN_CREDIT_ACCOUNT_IOC"});
        return ApiResult.ok();
    }

    public CreditAccountIocServiceImpl(CreditAccountIocDomainService creditAccountIocDomainService, RedisUtils redisUtils) {
        this.creditAccountIocDomainService = creditAccountIocDomainService;
        this.redisUtils = redisUtils;
    }
}

