/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyApConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyApQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApVO;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyApService;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyApDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyApRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FinApPayVerApplyApServiceImpl
implements FinApPayVerApplyApService {
    private final FinApPayVerApplyApRepoProc finApPayVerApplyApRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final ApOrderRepoProc apOrderRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(Long masId, List<FinApPayVerApplyApSaveDTO> saveList) {
        Assert.notNull((Object)masId, (String)"\u4e3b\u8868ID\u4e0d\u80fd\u4e3aNull");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List<String> apDocNoList = saveList.stream().map(FinApPayVerApplyApSaveDTO::getApDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ApOrderDTO> apOrderDTOList = this.apOrderRepoProc.selectInOutCustByApOrderNo(apDocNoList);
        HashMap apOrderMap = CollectionUtil.isEmpty(apOrderDTOList) ? new HashMap() : apOrderDTOList.stream().collect(Collectors.toMap(ApOrderDTO::getApOrderNo, t -> t, (t1, t2) -> t1));
        this.finApPayVerApplyApRepoProc.save(saveList.stream().map(e -> {
            FinApPayVerApplyApDO entity = FinApPayVerApplyApConvert.INSTANCE.save2Do((FinApPayVerApplyApSaveDTO)e);
            entity.setMasId(masId);
            ApOrderDTO apOrderDTO = (ApOrderDTO)apOrderMap.get(entity.getApDocNo());
            if (Objects.nonNull(apOrderDTO)) {
                String inOutCust = StringUtils.isBlank((CharSequence)entity.getInOutCust()) ? apOrderDTO.getInOutCust() : entity.getInOutCust();
                String relevanceOuCode = StringUtils.isBlank((CharSequence)entity.getRelevanceOuCode()) ? apOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                entity.setInOutCust(inOutCust);
                entity.setRelevanceOuCode(relevanceOuCode);
            }
            return entity;
        }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Collection<Long> masIds) {
        this.finApPayVerApplyApRepoProc.deleteByMasId(masIds);
    }

    @Override
    @SysCodeProc
    public List<FinApPayVerApplyApVO> listByMasIds(Collection<Long> masIds) {
        List<FinApPayVerApplyApVO> finApPayVerApplyApVOList = this.finApPayVerApplyApRepoProc.listByMasIds(masIds).stream().map(FinApPayVerApplyApConvert.INSTANCE::entity2Vo).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finApPayVerApplyApVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finApPayVerApplyApVOList.stream().map(FinApPayVerApplyApVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finApPayVerApplyApVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return finApPayVerApplyApVOList;
    }

    @Override
    public List<FinApPayVerApplyApVO> listByQuery(FinApPayVerApplyApQuery query) {
        return this.finApPayVerApplyApRepoProc.listByQuery(query).stream().map(FinApPayVerApplyApConvert.INSTANCE::entity2Vo).collect(Collectors.toList());
    }

    @Override
    public List<FinApPayVerApplyApVO> listByOutArDocNoOrDId(FinApPayVerApplyQuery applyQuery) {
        return this.finApPayVerApplyApRepoProc.listByOutApDocNoOrDId(applyQuery);
    }

    public FinApPayVerApplyApServiceImpl(FinApPayVerApplyApRepoProc finApPayVerApplyApRepoProc, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, ApOrderRepoProc apOrderRepoProc) {
        this.finApPayVerApplyApRepoProc = finApPayVerApplyApRepoProc;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.apOrderRepoProc = apOrderRepoProc;
    }
}

