/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.rpc.workflow;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class WorkflowRpcServiceImpl
implements WorkflowRpcService {
    private final WorkflowService workflowService;
    private final SysSettingService sysSettingService;

    @Override
    public ProcessInfo startProcess(String procKey, String procInstName, String businessKey, HashMap<String, Object> variables) {
        if (this.checkIsEnableWorkFlow(procKey).booleanValue()) {
            StartProcessPayload startProcessPayload = StartProcessPayload.of((String)procKey, (String)procInstName, (String)businessKey, variables);
            WorkflowResult processInfoWorkflowResult = this.workflowService.startProcess(startProcessPayload);
            if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:" + processInfoWorkflowResult.getMsg());
            }
            return (ProcessInfo)processInfoWorkflowResult.getData();
        }
        return new ProcessInfo();
    }

    @Override
    public ProcessInfo startProcess(String procKey, String procInstName, String businessKey, HashMap<String, Object> variables, String starterId, String tenantId) {
        if (this.checkIsEnableWorkFlow(procKey).booleanValue()) {
            StartProcessPayload startProcessPayload = StartProcessPayload.of((String)procKey, (String)procInstName, (String)businessKey, variables);
            startProcessPayload.setStarterId(starterId);
            startProcessPayload.setTenantId(tenantId);
            WorkflowResult processInfoWorkflowResult = this.workflowService.startProcess(startProcessPayload);
            if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:" + processInfoWorkflowResult.getMsg());
            }
            return (ProcessInfo)processInfoWorkflowResult.getData();
        }
        return new ProcessInfo();
    }

    @Override
    public Boolean checkIsEnableWorkFlow(String workFlowKey) {
        SysSettingVO sysSetting = this.findSysSettingByNo(workFlowKey);
        return ObjectUtil.isNull((Object)sysSetting) || "1".equals(sysSetting.getSettingVal());
    }

    public SysSettingVO findSysSettingByNo(String no) {
        try {
            return this.sysSettingService.oneByNo(no);
        }
        catch (Exception e) {
            throw new com.elitescloud.boot.exception.BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u7cfb\u7edf\u8bbe\u7f6e\u8868\u6570\u636e\u63a5\u53e3\u5f02\u5e38:" + e);
        }
    }

    public WorkflowRpcServiceImpl(WorkflowService workflowService, SysSettingService sysSettingService) {
        this.workflowService = workflowService;
        this.sysSettingService = sysSettingService;
    }
}

