package com.elitesland.fin.application.facade.vo.expense;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Mark
 * @date 2024/08/13 14:23
 */
@Data
@ApiModel("分页传输类")
public class ExpRuleConfigPageVO extends BaseModelVO implements Serializable {

    @ApiModelProperty("账户规则码")
    private String ruleCode;

    @ApiModelProperty("账户规则名称")
    private String ruleName;

    @ApiModelProperty("费用类型编码")
    private String expTypeCode;

    @ApiModelProperty("费用类型名称")
    private String expTypeName;

    @ApiModelProperty("是否启用")
    private Boolean enableFlag;

    @ApiModelProperty("计算方式 1固定金额/2固定比例")
    @SysCode(sys = "yst-fin", mod = "CAL_TYPE")
    private String calculateType;
    private String calculateTypeName;

    @ApiModelProperty("计算政策")
    private BigDecimal calculateStrategy;

    @ApiModelProperty(value = "台账自动审核 1-是 0-否")
    private boolean automaticReview;

    @ApiModelProperty(value = "优先级")
    private Integer priorityNo;

    private BigDecimal calculatePercent;

    private BigDecimal uomAmt;

}