package com.elitesland.fin.domain.service.creditaccount;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountRuleConfigConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountRuleConfigDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigQueryVO;
import com.elitesland.fin.entity.creditaccount.CreditAccountRuleConfigDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRuleConfigRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRuleConfigRepoProc;
import lombok.AllArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Service
@AllArgsConstructor
@Transactional
public class CreditAccountRuleConfigDomainServiceImpl implements CreditAccountRuleConfigDomainService {

    private final CreditAccountRuleConfigRepo accountRuleConfigRepo;

    private final CreditAccountRuleConfigRepoProc accountRuleConfigRepoProc;

    @Override
    @SysCodeProc
    public Optional<CreditAccountRuleConfigDO> findById(Long id) {
        if (StringUtils.isEmpty(id)) {
            return Optional.empty();
        }
        return accountRuleConfigRepo.findById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteById(Long id) {
        accountRuleConfigRepo.deleteById(id);
    }

    @Override
    public void updateDynamically(CreditAccountRuleConfigDO invSceneConfigDO) {
        accountRuleConfigRepoProc.updateDynamically(invSceneConfigDO);
    }

    @Override
    public PagingVO<CreditAccountRuleConfigPageVO> searchPage(CreditAccountRuleConfigQueryParam param) {
        return accountRuleConfigRepoProc.searchPage(param);
    }

    @Override
    public List<CreditAccountRuleConfigQueryVO> findRuleConfigByRuleCode(String ruleCode) {
        List<CreditAccountRuleConfigDO> sceneConfigDOS = accountRuleConfigRepo.findAllByRuleCode(ruleCode);
        return sceneConfigDOS.stream().map(CreditAccountRuleConfigConvert.INSTANCE::do2VO)
                .collect(Collectors.toList());
    }

    @Override
    public CreditAccountRuleConfigDTO findByRuleCode(String ruleCode) {
        List<CreditAccountRuleConfigDO> sceneConfigDOS = accountRuleConfigRepo.findAllByRuleCode(ruleCode);
        if (!CollectionUtils.isEmpty(sceneConfigDOS)) {
            return CreditAccountRuleConfigConvert.INSTANCE.do2DTO(sceneConfigDOS.get(0));
        } else {
            return null;
        }
    }

}
