/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.fin.application.convert.invoice.InvoiceConvert;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtl;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepoProc;
import com.elitesland.fin.param.saleinv.InvoiceQueryParam;
import com.elitesland.fin.param.saleinv.InvoiceSaveParam;
import com.elitesland.fin.param.saleinv.XforceResult;
import com.elitesland.fin.repo.invoice.InvoiceApplyRepoProc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceApplyServiceImpl
implements InvoiceApplyService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceApplyServiceImpl.class);
    private final SeqNumProvider sysNumberRuleService;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final SaleInvdDtlRepo saleInvdDtlRepo;
    private final SaleInvdDtlRepoProc saleInvdDtlRepoProc;
    private final SaleInvRepoProc saleInvRepoProc;
    private final InvoiceApplyRepoProc invoiceApplyRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InvoiceApplyRpcDTO> create(List<InvoiceApplySaveParam> paramList) {
        List saleInvDOList;
        ArrayList<InvoiceApplyRpcDTO> resultList = new ArrayList<InvoiceApplyRpcDTO>();
        HashMap saleInvDOMapS = new HashMap();
        HashMap<String, List> saleInvDtlDOMapS = new HashMap<String, List>();
        paramList.forEach(param -> {
            SaleInv saleInv = InvoiceConvert.INSTANCE.toSaleInv((InvoiceApplySaveParam)param);
            saleInv.check();
            this.checkDtl(saleInv.getSaleInvDtls());
            String applyNo = this.sysNumberRuleService.generateCode("yst-fin", "XXFP", null);
            saleInv.setApplyNo(applyNo);
            SaleInvDO convertDO = SaleInvConvert.INSTANCE.convert(saleInv);
            convertDO.setSourceSysNo(param.getSourceSysNo());
            saleInvDOMapS.put(applyNo, convertDO);
            List<SaleInvDtlDO> details = SaleInvConvert.INSTANCE.convertListDO(saleInv.getSaleInvDtls());
            saleInvDtlDOMapS.put(applyNo, details);
            param.setApplyNo(applyNo);
        });
        if (!CollectionUtils.isEmpty(saleInvDOMapS) && !CollectionUtils.isEmpty((Collection)(saleInvDOList = this.saleInvRepo.saveAll(saleInvDOMapS.values())))) {
            HashMap applyNoAndIdMap = new HashMap();
            saleInvDOList.forEach(saleInvDO -> {
                applyNoAndIdMap.put(saleInvDO.getApplyNo(), saleInvDO.getId());
                InvoiceApplyRpcDTO result = new InvoiceApplyRpcDTO();
                result.setApplyId(saleInvDO.getId());
                result.setApplyNo(saleInvDO.getApplyNo());
                resultList.add(result);
            });
            if (!CollectionUtils.isEmpty(saleInvDtlDOMapS)) {
                ArrayList saleInvDtlDOS = new ArrayList();
                saleInvDtlDOMapS.forEach((key, value) -> {
                    Long masId = (Long)applyNoAndIdMap.get(key);
                    value.forEach(v -> {
                        v.setMasId(masId);
                        saleInvDtlDOS.add(v);
                    });
                });
                List<Long> collect = saleInvDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
                this.saleInvDtlRepoProc.delByMasId(collect);
                this.saleInvDtlRepo.saveAll(saleInvDtlDOS);
            }
        }
        return resultList;
    }

    public void checkDtl(List<SaleInvDtl> saleInvDtls) {
        if (CollUtil.isEmpty(saleInvDtls)) {
            throw new BusinessException("\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        saleInvDtls.forEach(v -> {
            Assert.notEmpty((CharSequence)v.getUom(), (String)"uom is null", (Object[])new Object[0]);
            Assert.notNull((Object)v.getQty(), (String)"qty is null", (Object[])new Object[0]);
            Assert.notNull((Object)v.getPrice(), (String)"price is null", (Object[])new Object[0]);
            Assert.notNull((Object)v.getTotalAmt(), (String)"totalAmt is null", (Object[])new Object[0]);
            Assert.notNull((Object)v.getTaxRate(), (String)"taxRate is null", (Object[])new Object[0]);
            Assert.notNull((Object)v.getTaxAmt(), (String)"taxAmt is null", (Object[])new Object[0]);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveInvoice(List<InvoiceSaveParam> param) {
        if (CollUtil.isNotEmpty(param)) {
            this.saleInvdDtlRepoProc.delByMasId(List.of(param.get(0).getMasId()));
            List<SaleInvdDtlDO> details = InvoiceConvert.INSTANCE.convertInvd(param);
            this.saleInvdDtlRepo.saveAll(details);
        }
    }

    @Override
    public InvoiceApplyRpcDTO queryIdByApplyNo(String applyNo) {
        SaleInvDO saleInvDO = this.saleInvRepo.findByApplyNo(applyNo);
        if (ObjectUtil.isNull((Object)saleInvDO)) {
            throw new BusinessException("[TIMS-FIN] " + applyNo + " \u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        InvoiceApplyRpcDTO applyRpcDTO = InvoiceConvert.INSTANCE.doToDTO(saleInvDO);
        List<SaleInvDtlDTO> details = this.saleInvDtlRepoProc.getList(saleInvDO.getId());
        List paymentNoList = details.stream().map(SaleInvDtlDTO::getSourceNo).collect(Collectors.toList());
        List paymentIds = details.stream().map(SaleInvDtlDTO::getSourceId).distinct().collect(Collectors.toList());
        applyRpcDTO.setPaymentNoList(paymentNoList);
        applyRpcDTO.setPaymentIds(paymentIds);
        List<SaleInvdDtlDTO> invd = this.saleInvdDtlRepoProc.getList(saleInvDO.getId());
        List redState = invd.stream().map(SaleInvdDtlDTO::getRedState).collect(Collectors.toList());
        applyRpcDTO.setRedState(redState);
        return applyRpcDTO;
    }

    @Override
    public List<InvoiceApplyRpcDTO> queryIdBySource(InvoiceQueryParam param) {
        return this.invoiceApplyRepoProc.queryIdBySource(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateXforceResult(XforceResult param) {
        this.saleInvRepoProc.updateExternalInfo(param.getApplyNo(), param.getXforceStatus(), param.getXforceReason());
    }

    public InvoiceApplyServiceImpl(SeqNumProvider sysNumberRuleService, SaleInvRepo saleInvRepo, SaleInvDtlRepoProc saleInvDtlRepoProc, SaleInvDtlRepo saleInvDtlRepo, SaleInvdDtlRepo saleInvdDtlRepo, SaleInvdDtlRepoProc saleInvdDtlRepoProc, SaleInvRepoProc saleInvRepoProc, InvoiceApplyRepoProc invoiceApplyRepoProc) {
        this.sysNumberRuleService = sysNumberRuleService;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
        this.saleInvDtlRepo = saleInvDtlRepo;
        this.saleInvdDtlRepo = saleInvdDtlRepo;
        this.saleInvdDtlRepoProc = saleInvdDtlRepoProc;
        this.saleInvRepoProc = saleInvRepoProc;
        this.invoiceApplyRepoProc = invoiceApplyRepoProc;
    }
}

