/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyPayConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPaySaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyPayQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayVO;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyPayService;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyPayDO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FinApPayVerApplyPayServiceImpl
implements FinApPayVerApplyPayService {
    private final FinApPayVerApplyPayRepoProc finApPayVerApplyPayRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final PayOrderRepoProc payOrderRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(Long masId, List<FinApPayVerApplyPaySaveDTO> saveList) {
        Assert.notNull((Object)masId, (String)"\u4e3b\u8868ID\u4e0d\u80fd\u4e3aNull");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List<String> payDocNoList = saveList.stream().map(FinApPayVerApplyPaySaveDTO::getPayDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<PayOrderDTO> payOrderDTOList = this.payOrderRepoProc.selectInOutCustByPayOrderNo(payDocNoList);
        HashMap payOrderMap = CollectionUtil.isEmpty(payOrderDTOList) ? new HashMap() : payOrderDTOList.stream().collect(Collectors.toMap(PayOrderDTO::getPayOrderNo, t -> t, (t1, t2) -> t1));
        this.finApPayVerApplyPayRepoProc.save(saveList.stream().map(e -> {
            FinApPayVerApplyPayDO entity = FinApPayVerApplyPayConvert.INSTANCE.save2Do((FinApPayVerApplyPaySaveDTO)e);
            entity.setMasId(masId);
            PayOrderDTO payOrderDTO = (PayOrderDTO)payOrderMap.get(entity.getPayDocNo());
            if (Objects.nonNull(payOrderDTO)) {
                String inOutCust = StringUtils.isBlank((CharSequence)entity.getInOutCust()) ? payOrderDTO.getInOutCust() : entity.getInOutCust();
                String relevanceOuCode = StringUtils.isBlank((CharSequence)entity.getRelevanceOuCode()) ? payOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                entity.setInOutCust(inOutCust);
                entity.setRelevanceOuCode(relevanceOuCode);
            }
            return entity;
        }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Collection<Long> masIds) {
        this.finApPayVerApplyPayRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinApPayVerApplyPayVO> listByMasIds(Collection<Long> masIds) {
        List<FinApPayVerApplyPayVO> finApPayVerApplyPayVOList = this.finApPayVerApplyPayRepoProc.listByMasIds(masIds).stream().map(FinApPayVerApplyPayConvert.INSTANCE::entity2Vo).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finApPayVerApplyPayVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finApPayVerApplyPayVOList.stream().map(FinApPayVerApplyPayVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finApPayVerApplyPayVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return finApPayVerApplyPayVOList;
    }

    @Override
    public List<FinApPayVerApplyPayVO> listByQuery(FinApPayVerApplyPayQuery query) {
        return this.finApPayVerApplyPayRepoProc.listByQuery(query).stream().map(FinApPayVerApplyPayConvert.INSTANCE::entity2Vo).collect(Collectors.toList());
    }

    @Override
    public List<FinApPayVerApplyPayVO> listByOutRecDocNoOrDId(FinApPayVerApplyQuery query) {
        return this.finApPayVerApplyPayRepoProc.listByOutRecDocNoOrDId(query);
    }

    public FinApPayVerApplyPayServiceImpl(FinApPayVerApplyPayRepoProc finApPayVerApplyPayRepoProc, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, PayOrderRepoProc payOrderRepoProc) {
        this.finApPayVerApplyPayRepoProc = finApPayVerApplyPayRepoProc;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.payOrderRepoProc = payOrderRepoProc;
    }
}

