/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.aisino.service;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infinity.aisino.entity.AisinoLogDO;
import com.elitesland.fin.infinity.aisino.enums.RedStateEnum;
import com.elitesland.fin.infinity.aisino.repo.AisinoLogRepo;
import com.elitesland.fin.infinity.aisino.service.AisinoPayloadService;
import com.elitesland.fin.infinity.aisino.service.AisinoService;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoCoverParamPayload;
import com.elitesland.fin.infinity.aisino.vo.param.invoice.InvoiceMain;
import com.elitesland.fin.infinity.aisino.vo.param.notice.InvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoCoverRespVO;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoRedInitialResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoRedOpenResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoRedSaveResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.BlueInvoiceApplyRespVO;
import com.elitesland.fin.infinity.aisino.vo.resp.InvoiceResultRespVO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.param.saleinv.InvoiceSaveParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import com.saobei.open.sdk.util.HttpClientUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class AisinoServiceImpl
implements AisinoService {
    private static final Logger log = LoggerFactory.getLogger(AisinoServiceImpl.class);
    private final AisinoLogRepo aisinoLogRepo;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;
    private final TaskExecutor taskExecutor;
    @Autowired
    @Lazy
    private InvoiceAwaitService invoiceAwaitService;
    @Autowired
    private InvoiceRedraftRepo invoiceRedraftRepo;
    private final InvoiceApplyService invoiceApplyService;
    private final AisinoPayloadService aisinoPayloadService;
    @Value(value="${aisino.api.url:http://221.234.42.184:9236}")
    private String baseUrl;

    @Override
    public void addLog(String type, String name, String param, String param2) {
        AisinoLogDO xforceLog = new AisinoLogDO();
        xforceLog.setRequestType(type);
        xforceLog.setRequestTypeName(name);
        xforceLog.setRequestParam(param);
        xforceLog.setRequestParam2(param2);
        this.aisinoLogRepo.save(xforceLog);
    }

    private AisinoCoverRespVO getAisinoApplyRespVO(String url, String jsonString) {
        String responseStr;
        try {
            responseStr = HttpClientUtil.post((String)url, (String)jsonString, (int)8000, (String)"application/json", (String)"utf-8");
            if (responseStr == null) {
                throw new BusinessException("\u822a\u4fe1\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            log.error("\u822a\u4fe1\u63a5\u53e3\u8c03\u7528\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new BusinessException(e.getMessage());
        }
        return (AisinoCoverRespVO)JSON.parseObject((String)responseStr, AisinoCoverRespVO.class);
    }

    @Override
    public BlueInvoiceApplyRespVO blueInvoiceApply(AisinoCoverParamPayload payload, String originParam) {
        String url = this.baseUrl + "/openapi/qd/qpt/Kp_Fpkj";
        String finalParam = JSON.toJSONString((Object)payload);
        log.info("\u84dd\u7968\u7533\u8bf7\u5730\u5740\uff1a{},\u5165\u53c2: {}", (Object)url, (Object)finalParam);
        this.addLog("AISINO_BLUE_INVOICE_APPLY", "\u822a\u4fe1\u5f00\u7968\u4e0a\u4f20\u63a5\u53e3\uff1a\u53c2\u6570", finalParam, originParam);
        AisinoCoverRespVO responseVO = this.getAisinoApplyRespVO(url, finalParam);
        String responseVoStr = JSON.toJSONString((Object)responseVO);
        BlueInvoiceApplyRespVO decrypt = null;
        if (Objects.equals(responseVO.getCODE(), "200")) {
            String data = responseVO.getDATA();
            decrypt = this.aisinoPayloadService.decrypt(data, BlueInvoiceApplyRespVO.class);
        }
        this.addLog("AISINO_BLUE_INVOICE_APPLY", "\u822a\u4fe1\u5f00\u7968\u4e0a\u4f20\u63a5\u53e3\uff1a\u7ed3\u679c", responseVoStr, decrypt == null ? null : JSON.toJSONString(decrypt));
        return decrypt;
    }

    @Override
    public AisinoResultResp blueInvoiceResult(AisinoCoverParamPayload payload, String originParam) {
        String url = this.baseUrl + "/openapi/qd/qpt/Yp_FpUrl";
        String finalParam = JSON.toJSONString((Object)payload);
        log.info("\u84dd\u7968\u83b7\u53d6\u5165\u53c2: {}", (Object)finalParam);
        this.addLog("AISINO_BLUE_RESULT", "\u83b7\u53d6\u84dd\u7968\u8fd4\u56de\uff1a\u53c2\u6570", finalParam, originParam);
        AisinoCoverRespVO responseVO = this.getAisinoApplyRespVO(url, finalParam);
        String responseVoStr = JSON.toJSONString((Object)responseVO);
        AisinoResultResp decrypt = null;
        if (Objects.equals(responseVO.getCODE(), "200")) {
            String data = responseVO.getDATA();
            decrypt = this.aisinoPayloadService.decrypt(data, AisinoResultResp.class);
        }
        this.addLog("AISINO_BLUE_RESULT", "\u83b7\u53d6\u84dd\u7968\u8fd4\u56de\uff1a\u7ed3\u679c", responseVoStr, decrypt == null ? null : JSON.toJSONString(decrypt));
        return decrypt;
    }

    @Override
    public AisinoResultResp blueInvoiceResultBase64(AisinoCoverParamPayload payload, String originParam) {
        String url = this.baseUrl + "/openapi/qd/qpt/Yp_Down";
        String finalParam = JSON.toJSONString((Object)payload);
        log.info("\u84dd\u7968Base64\u83b7\u53d6\u5165\u53c2: {}", (Object)finalParam);
        this.addLog("AISINO_BLUE_BASE64_RESULT", "\u83b7\u53d6\u84dd\u7968Base64\u8fd4\u56de\uff1a\u53c2\u6570", finalParam, originParam);
        AisinoCoverRespVO responseVO = this.getAisinoApplyRespVO(url, finalParam);
        String responseVoStr = JSON.toJSONString((Object)responseVO);
        AisinoResultResp decrypt = null;
        if (Objects.equals(responseVO.getCODE(), "200")) {
            String data = responseVO.getDATA();
            decrypt = this.aisinoPayloadService.decrypt(data, AisinoResultResp.class);
        }
        this.addLog("AISINO_BLUE_BASE64_RESULT", "\u83b7\u53d6\u84dd\u7968Base64\u8fd4\u56de\uff1a\u7ed3\u679c", responseVoStr, decrypt == null ? null : JSON.toJSONString(decrypt));
        return decrypt;
    }

    @Override
    public AisinoRedInitialResultResp redInvoiceInitial(AisinoCoverParamPayload payload, String originParam) {
        String jsonString = JSON.toJSONString((Object)payload);
        String url = this.baseUrl + "/openapi/qd/qpt/Kp_RedBillInit";
        this.addLog("AISINO_RED_INITIAL", "\u7ea2\u7968\u521d\u59cb\u5316\u7ed3\u679c\u53cd\u9988\u63a5\u53e3\uff1a\u53c2\u6570", jsonString, originParam);
        AisinoCoverRespVO responseVO = this.getAisinoApplyRespVO(url, jsonString);
        String responseVoStr = JSON.toJSONString((Object)responseVO);
        AisinoRedInitialResultResp decrypt = null;
        if (Objects.equals(responseVO.getCODE(), "200")) {
            String data = responseVO.getDATA();
            decrypt = this.aisinoPayloadService.decrypt(data, AisinoRedInitialResultResp.class);
        }
        this.addLog("AISINO_RED_INITIAL", "\u7ea2\u7968\u521d\u59cb\u5316\u7ed3\u679c\u53cd\u9988\u63a5\u53e3\uff1a\u7ed3\u679c", responseVoStr, decrypt == null ? null : JSON.toJSONString(decrypt));
        return decrypt;
    }

    @Override
    public AisinoRedSaveResultResp redInvoiceSave(AisinoCoverParamPayload payload, String originParam) {
        String url = this.baseUrl + "/openapi/qd/qpt/Kp_RedBillSave";
        String jsonString = JSON.toJSONString((Object)payload);
        this.addLog("AISINO_RED_SAVE", "\u7ea2\u7968\u4fdd\u5b58\u7ed3\u679c\u53cd\u9988\u63a5\u53e3\uff1a\u53c2\u6570", jsonString, originParam);
        AisinoCoverRespVO responseVO = this.getAisinoApplyRespVO(url, jsonString);
        String responseVoStr = JSON.toJSONString((Object)responseVO);
        AisinoRedSaveResultResp decrypt = null;
        if (Objects.equals(responseVO.getCODE(), "200")) {
            String data = responseVO.getDATA();
            decrypt = this.aisinoPayloadService.decrypt(data, AisinoRedSaveResultResp.class);
        }
        this.addLog("AISINO_RED_SAVE", "\u7ea2\u7968\u4fdd\u5b58\u7ed3\u679c\u53cd\u9988\u63a5\u53e3\uff1a\u7ed3\u679c", responseVoStr, decrypt == null ? null : JSON.toJSONString(decrypt));
        return decrypt;
    }

    @Override
    public AisinoRedOpenResultResp redInvoiceOpen(AisinoCoverParamPayload payload, String originParam) {
        String url = this.baseUrl + "/openapi/qd/qpt/Kp_RedIssue";
        String jsonString = JSON.toJSONString((Object)payload);
        this.addLog("AISINO_RED_OPEN", "\u7ea2\u7968\u5f00\u7968\u7ed3\u679c\u53cd\u9988\u63a5\u53e3\uff1a\u53c2\u6570", jsonString, originParam);
        AisinoCoverRespVO responseVO = this.getAisinoApplyRespVO(url, jsonString);
        String responseVoStr = JSON.toJSONString((Object)responseVO);
        AisinoRedOpenResultResp decrypt = null;
        if (Objects.equals(responseVO.getCODE(), "200")) {
            String data = responseVO.getDATA();
            decrypt = this.aisinoPayloadService.decrypt(data, AisinoRedOpenResultResp.class);
        }
        this.addLog("AISINO_RED_OPEN", "\u7ea2\u7968\u5f00\u7968\u7ed3\u679c\u53cd\u9988\u63a5\u53e3\uff1a\u7ed3\u679c", responseVoStr, decrypt == null ? null : JSON.toJSONString(decrypt));
        return decrypt;
    }

    @Override
    public InvoiceResultRespVO getInvoiceInfoByFlowNo(AisinoCoverParamPayload payload, String originParam) {
        String url = this.baseUrl + "/openapi/qd/qpt/Kp_GetFpByLsh";
        String jsonString = JSON.toJSONString((Object)payload);
        this.addLog("AISINO_INVOICE_INFO", "\u6839\u636e\u6d41\u6c34\u53f7\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\uff1a\u53c2\u6570", jsonString, originParam);
        AisinoCoverRespVO responseVO = this.getAisinoApplyRespVO(url, jsonString);
        String responseVoStr = JSON.toJSONString((Object)responseVO);
        InvoiceResultRespVO decrypt = null;
        if (Objects.equals(responseVO.getCODE(), "200")) {
            String data = responseVO.getDATA();
            decrypt = this.aisinoPayloadService.decrypt(data, InvoiceResultRespVO.class);
        }
        this.addLog("AISINO_INVOICE_INFO", "\u6839\u636e\u6d41\u6c34\u53f7\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\uff1a\u7ed3\u679c", responseVoStr, decrypt == null ? null : JSON.toJSONString(decrypt));
        return decrypt;
    }

    @Override
    public void saveInvoice(InvoiceParam invoiceParam) {
        ArrayList<InvoiceSaveParam> saveParams = new ArrayList<InvoiceSaveParam>();
        InvoiceMain invoiceMain = invoiceParam.getInvoiceMain();
        InvoiceApplyRpcDTO applyRpcDTO = this.invoiceApplyService.queryIdByApplyNo(invoiceMain.getSalesbillNo());
        Assert.notNull((Object)applyRpcDTO.getApplyId(), (String)(invoiceMain.getSalesbillNo() + " \u5355\u636e\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        InvoiceSaveParam saveParam = new InvoiceSaveParam();
        saveParam.setMasId(applyRpcDTO.getApplyId());
        saveParam.setInvNo(invoiceMain.getInvoiceNo());
        saveParam.setInvCode(invoiceMain.getInvoiceCode());
        saveParam.setFlowNo(invoiceMain.getBatchNo());
        saveParam.setCheckCode(invoiceMain.getCheckCode());
        saveParam.setBlueInvCode(invoiceMain.getOriginInvoiceCode());
        saveParam.setBlueInvNo(invoiceMain.getOriginInvoiceNo());
        saveParam.setTotalAmt(new BigDecimal(invoiceMain.getAmountWithTax()));
        saveParam.setInvDate(LocalDateTime.parse(invoiceMain.getPaperDrewDate()));
        saveParam.setRedState(invoiceMain.getRedStatus());
        saveParam.setInvState(invoiceMain.getStatus());
        saveParam.setInvPdfUrl(invoiceMain.getPdfPath());
        saveParam.setInvFailCause("");
        saveParams.add(saveParam);
        this.invoiceApplyService.saveInvoice(saveParams);
        CompletableFuture.runAsync(() -> this.handleOutcomeOfInvoice(invoiceMain, applyRpcDTO), (Executor)this.taskExecutor);
    }

    private void handleOutcomeOfInvoice(InvoiceMain invoiceMain, InvoiceApplyRpcDTO applyRpcDTO) {
        log.info("\u5f00\u59cb\u786e\u8ba4\u5173\u8054\u5355\u636e\u72b6\u6001,\u5f00\u7968\u72b6\u6001:{},\u7ea2\u51b2\u72b6\u6001:{},\u5f00\u7968\u7533\u8bf7\u5355\u5165\u53c2:{}", new Object[]{invoiceMain.getStatus(), invoiceMain.getRedStatus(), JSON.toJSONString((Object)applyRpcDTO)});
        List sourceDocNoList = applyRpcDTO.getPaymentNoList();
        if (RedStateEnum.RED_PUNCH.getCode().equals(invoiceMain.getRedStatus())) {
            InvoiceRedraftDO invoiceRedraftDO;
            SaleInvDO saleInvDO = this.saleInvRepo.findByApplyNo(invoiceMain.getSalesbillNo());
            if (!Objects.isNull(saleInvDO)) {
                log.error("\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u5355\u53f7\u4e3a\uff1a{}", (Object)invoiceMain.getSalesbillNo());
            }
            List<SaleInvDtlDTO> saleInvDtlDTOList = this.saleInvDtlRepoProc.getList(saleInvDO.getId());
            ArrayList<Long> salInvDtlIdList = new ArrayList();
            if (!CollectionUtils.isEmpty(saleInvDtlDTOList)) {
                salInvDtlIdList = saleInvDtlDTOList.stream().map(SaleInvDtlDTO::getSourceLineId).collect(Collectors.toList());
            }
            if (!ObjectUtils.isEmpty((Object)((Object)(invoiceRedraftDO = this.invoiceRedraftRepo.findByOrigApplyNo(invoiceMain.getSalesbillNo())))) && ProcInstStatus.APPROVED.equals((Object)invoiceRedraftDO.getWorkflowProcInstStatus()) && ObjectUtils.isEmpty((Object)invoiceRedraftDO.getOrigApplyNo())) {
                log.info("\u7ea2\u51b2\u540e\u5f00\u59cb\u521b\u5efa\u65b0\u7684\u5f00\u7968\u7533\u8bf7\u5355");
                this.createInvoice(applyRpcDTO, saleInvDO, salInvDtlIdList, invoiceRedraftDO);
            }
        }
    }

    private void createInvoice(InvoiceApplyRpcDTO applyRpcDTO, SaleInvDO saleInvDO, List<Long> paymentRecordDetailIdList, InvoiceRedraftDO invoiceRedraftDO) {
        InvoiceApplyParam param = new InvoiceApplyParam();
        param.setOptDocNos(applyRpcDTO.getPaymentNoList());
        param.setIds(applyRpcDTO.getPaymentIds());
        if (!CollectionUtils.isEmpty(paymentRecordDetailIdList)) {
            param.setBizDtlKey(paymentRecordDetailIdList);
        }
        param.setCustTaxNo(saleInvDO.getCustTaxNo());
        param.setCustInvTitle(saleInvDO.getCustInvTitle());
        param.setAddress(saleInvDO.getCustAdd());
        param.setCustBank(saleInvDO.getCustBank());
        param.setCustBankAcc(saleInvDO.getCustBankAcc());
        param.setCustTel(saleInvDO.getCustTel());
        param.setInvType(invoiceRedraftDO.getInvoiceType());
        log.info("\u5f00\u59cb\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)param));
        List<InvoiceSaveVO> saveList = this.invoiceAwaitService.invoiceApply(param);
        log.info("\u4fdd\u5b58\u5f00\u7968\u7533\u8bf7\u5355\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString(saveList));
        if (!CollectionUtils.isEmpty(saveList)) {
            for (InvoiceSaveVO save : saveList) {
                if (!Objects.isNull(save.getApplyNo())) {
                    log.info("\u5f00\u59cb\u6267\u884c\u66f4\u65b0\u65b0\u7533\u8bf7\u5355\u53f7\u66f4\u65b0\u8bed\u53e5\uff0c\u6570\u636e\u4e3a{},id:{}", (Object)save.getApplyNo(), (Object)invoiceRedraftDO.getId());
                }
                JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.redraftApplyNo, (Object)save.getApplyNo()).where(new Predicate[]{this.qdo.id.eq((Object)invoiceRedraftDO.getId())});
                log.info("\u6253\u5370\u6267\u884c\u8bed\u53e5");
                update.execute();
            }
        }
    }

    public AisinoServiceImpl(AisinoLogRepo aisinoLogRepo, SaleInvRepo saleInvRepo, SaleInvDtlRepoProc saleInvDtlRepoProc, JPAQueryFactory jpaQueryFactory, TaskExecutor taskExecutor, InvoiceApplyService invoiceApplyService, AisinoPayloadService aisinoPayloadService) {
        this.aisinoLogRepo = aisinoLogRepo;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.taskExecutor = taskExecutor;
        this.invoiceApplyService = invoiceApplyService;
        this.aisinoPayloadService = aisinoPayloadService;
    }
}

