/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.aporder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.service.arorder.ApArOrderService;
import com.elitesland.fin.application.service.inputinv.InputInvService;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.dto.aporder.ApArOrderHandleRpcDTO;
import com.elitesland.fin.dto.aporder.ApOrderRpcDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ApArOrderHandleDTO;
import com.elitesland.fin.param.aporder.ApArOrderHandleRpcParam;
import com.elitesland.fin.param.aporder.ApOrderPageRpcParam;
import com.elitesland.fin.param.aporder.ApOrderRpcParam;
import com.elitesland.fin.service.aporder.ApOrderRpcService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/apOrder"})
public class ApOrderRpcServiceImpl
implements ApOrderRpcService {
    public final ApOrderDomainService apOrderDomainService;
    public final InputInvService inputInvService;
    public final ApArOrderService apArOrderService;

    public ApiResult<Long> save(ApOrderRpcParam apOrderRpcParam) {
        if (StringUtils.isBlank((CharSequence)apOrderRpcParam.getCreateMode())) {
            throw new BusinessException("\u5355\u636e\u6765\u6e90 createMode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ApOrder apOrder = ApOrderConvert.INSTANCE.convertRpc(apOrderRpcParam);
        Long resId = this.apOrderDomainService.save(apOrder);
        if (Boolean.TRUE.equals(apOrderRpcParam.getWriteInvFlag())) {
            ApOrderDTO apOrderDTO = this.apOrderDomainService.get(resId);
            this.inputInvService.savaApOrderNo(apOrderRpcParam.getCreateMode(), apOrderRpcParam.getSourceNo(), apOrderDTO.getApOrderNo());
        }
        return ApiResult.ok((Object)resId);
    }

    public ApiResult<ApOrderRpcDTO> queryApOrderById(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderDomainService.getApOrderAndDtl(id);
        return ApiResult.ok((Object)ApOrderConvert.INSTANCE.apOrderDTO2ApOrderRpcDTO(apOrderDTO));
    }

    public ApiResult<PagingVO<ApOrderRpcDTO>> page(ApOrderPageRpcParam apOrderPageRpcParam) {
        ApOrderPageParam apOrderPageParam = ApOrderConvert.INSTANCE.convertPageParamRpc(apOrderPageRpcParam);
        PagingVO<ApOrderRpcDTO> res = ApOrderConvert.INSTANCE.convertRpcDto(this.apOrderDomainService.page(apOrderPageParam));
        return ApiResult.ok(res);
    }

    public ApiResult<ApArOrderHandleRpcDTO> invInterTranGenApAr(@RequestBody ApArOrderHandleRpcParam apArOrderRpcParam) {
        ApArOrderHandleRpcDTO apArOrderHandleRpcDTO = new ApArOrderHandleRpcDTO();
        ApOrder apOrder = ApOrderConvert.INSTANCE.invInterTranGenConvert(apArOrderRpcParam.getApOrderRpcParam());
        ArOrder arOrder = ArOrderConvert.INSTANCE.invInterTranGenConvert(apArOrderRpcParam.getArOrderRpcParam());
        ApArOrderHandleDTO apArOrderHandleDTO = this.apArOrderService.invInterTranCreateApArOrder(apOrder, arOrder);
        apArOrderHandleRpcDTO.setArResId(apArOrderHandleDTO.getArResId());
        apArOrderHandleRpcDTO.setArOrderNo(apArOrderHandleDTO.getArOrderNo());
        apArOrderHandleRpcDTO.setApResId(apArOrderHandleDTO.getApResId());
        apArOrderHandleRpcDTO.setApOrderNo(apArOrderHandleDTO.getApOrderNo());
        return ApiResult.ok((Object)apArOrderHandleRpcDTO);
    }

    public ApOrderRpcServiceImpl(ApOrderDomainService apOrderDomainService, InputInvService inputInvService, ApArOrderService apArOrderService) {
        this.apOrderDomainService = apOrderDomainService;
        this.inputInvService = inputInvService;
        this.apArOrderService = apArOrderService;
    }
}

