/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.invoice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.entity.invoice.InvoiceRuleConfigDO;
import com.elitesland.fin.entity.invoice.QInvoiceRuleConfigDO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class InvoiceRuleConfigRepoProc {
    private static final QInvoiceRuleConfigDO qdo = QInvoiceRuleConfigDO.invoiceRuleConfigDO;
    private final JPAQueryFactory jpaQueryFactory;

    public PagingVO<InvoiceRuleConfigDTO> queryPaging(InvoiceRuleConfigQueryParam param) {
        List<Predicate> where = this.where(param);
        JPAQuery query = (JPAQuery)this.select(InvoiceRuleConfigDTO.class).where(ExpressionUtils.allOf(where));
        param.setPaging(query);
        param.fillOrders(query, qdo);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<InvoiceRuleConfigDTO> getList(List<InvoiceRuleConfigQueryParam> param) {
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        for (InvoiceRuleConfigQueryParam invoiceRuleConfigQueryParam : param) {
            Predicate predicate = this.whereConfig(invoiceRuleConfigQueryParam);
            predicateList.add(predicate);
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.select(InvoiceRuleConfigDTO.class).where(ExpressionUtils.anyOf(predicateList))).orderBy(InvoiceRuleConfigRepoProc.qdo.createTime.desc());
        return jpaQuery.fetch();
    }

    public List<InvoiceRuleConfigDTO> getListByParam(InvoiceRuleConfigQueryParam param) {
        Predicate predicate = this.whereConfig(param);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.select(InvoiceRuleConfigDTO.class).where(predicate)).orderBy(InvoiceRuleConfigRepoProc.qdo.createTime.desc());
        return jpaQuery.fetch();
    }

    private Predicate whereConfig(InvoiceRuleConfigQueryParam param) {
        return BaseRepoProc.PredicateBuilder.builder().andEq(StrUtil.isNotBlank((CharSequence)param.getStatus()), (SimpleExpression)InvoiceRuleConfigRepoProc.qdo.status, (Object)param.getStatus()).andEq(StrUtil.isNotBlank((CharSequence)param.getOptDocCls()), (SimpleExpression)InvoiceRuleConfigRepoProc.qdo.optDocCls, (Object)param.getOptDocCls()).andEq(StrUtil.isNotBlank((CharSequence)param.getOptDocType()), (SimpleExpression)InvoiceRuleConfigRepoProc.qdo.optDocType, (Object)param.getOptDocType()).andIn(CollUtil.isNotEmpty(param.getOptDocTypes()), (SimpleExpression)InvoiceRuleConfigRepoProc.qdo.optDocType, param.getOptDocTypes()).andIn(CollUtil.isNotEmpty(param.getOptDocClss()), (SimpleExpression)InvoiceRuleConfigRepoProc.qdo.optDocCls, param.getOptDocClss()).andEq(StrUtil.isNotBlank((CharSequence)param.getOptDocStatus()), (SimpleExpression)InvoiceRuleConfigRepoProc.qdo.optDocStatus, (Object)param.getOptDocStatus()).andEq(StrUtil.isNotBlank((CharSequence)param.getOuCode()), (SimpleExpression)InvoiceRuleConfigRepoProc.qdo.ouCode, (Object)param.getOuCode()).andLike(StrUtil.isNotBlank((CharSequence)param.getOuName()), (StringExpression)InvoiceRuleConfigRepoProc.qdo.ouName, param.getOuName()).build();
    }

    private List<Predicate> where(InvoiceRuleConfigQueryParam param) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StrUtil.isNotBlank((CharSequence)param.getStatus())) {
            predicates.add((Predicate)InvoiceRuleConfigRepoProc.qdo.status.eq((Object)param.getStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getOptDocCls())) {
            predicates.add((Predicate)InvoiceRuleConfigRepoProc.qdo.optDocCls.eq((Object)param.getOptDocCls()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getOptDocType())) {
            predicates.add((Predicate)InvoiceRuleConfigRepoProc.qdo.optDocType.eq((Object)param.getOptDocType()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getOptDocStatus())) {
            predicates.add((Predicate)InvoiceRuleConfigRepoProc.qdo.optDocStatus.eq((Object)param.getOptDocStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getOuName())) {
            predicates.add((Predicate)InvoiceRuleConfigRepoProc.qdo.ouName.like("%" + param.getOuName() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getOuCode())) {
            predicates.add((Predicate)InvoiceRuleConfigRepoProc.qdo.ouCode.eq((Object)param.getOuCode()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{InvoiceRuleConfigRepoProc.qdo.id, InvoiceRuleConfigRepoProc.qdo.optDocCls, InvoiceRuleConfigRepoProc.qdo.optDocType, InvoiceRuleConfigRepoProc.qdo.optDocStatus, InvoiceRuleConfigRepoProc.qdo.invoiceLimit, InvoiceRuleConfigRepoProc.qdo.autoInvoice, InvoiceRuleConfigRepoProc.qdo.autoReview, InvoiceRuleConfigRepoProc.qdo.tenantId, InvoiceRuleConfigRepoProc.qdo.remark, InvoiceRuleConfigRepoProc.qdo.creator, InvoiceRuleConfigRepoProc.qdo.createUserId, InvoiceRuleConfigRepoProc.qdo.modifyUserId, InvoiceRuleConfigRepoProc.qdo.createTime, InvoiceRuleConfigRepoProc.qdo.modifyTime, InvoiceRuleConfigRepoProc.qdo.deleteFlag, InvoiceRuleConfigRepoProc.qdo.ouCode, InvoiceRuleConfigRepoProc.qdo.ouName, InvoiceRuleConfigRepoProc.qdo.needRedraft, InvoiceRuleConfigRepoProc.qdo.editInvTitle})).from((EntityPath)qdo);
    }

    public void update(InvoiceRuleConfigDO invoiceRuleConfigDO) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qdo);
        update.where(new Predicate[]{InvoiceRuleConfigRepoProc.qdo.id.eq((Object)invoiceRuleConfigDO.getId())});
        if (!ObjectUtils.isEmpty((Object)invoiceRuleConfigDO.getStatus())) {
            update.set((Path)InvoiceRuleConfigRepoProc.qdo.status, (Object)invoiceRuleConfigDO.getStatus());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRuleConfigDO.getOptDocCls())) {
            update.set((Path)InvoiceRuleConfigRepoProc.qdo.optDocCls, (Object)invoiceRuleConfigDO.getOptDocCls());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRuleConfigDO.getOptDocType())) {
            update.set((Path)InvoiceRuleConfigRepoProc.qdo.optDocType, (Object)invoiceRuleConfigDO.getOptDocType());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRuleConfigDO.getOptDocStatus())) {
            update.set((Path)InvoiceRuleConfigRepoProc.qdo.optDocStatus, (Object)invoiceRuleConfigDO.getOptDocStatus());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRuleConfigDO.getInvoiceLimit())) {
            update.set(InvoiceRuleConfigRepoProc.qdo.invoiceLimit, (Object)invoiceRuleConfigDO.getInvoiceLimit());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRuleConfigDO.getAutoReview())) {
            update.set(InvoiceRuleConfigRepoProc.qdo.autoReview, (Object)invoiceRuleConfigDO.getAutoReview());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRuleConfigDO.getAutoInvoice())) {
            update.set(InvoiceRuleConfigRepoProc.qdo.autoInvoice, (Object)invoiceRuleConfigDO.getAutoInvoice());
        }
        if (!ObjectUtils.isEmpty((Object)invoiceRuleConfigDO.getEditInvTitle())) {
            update.set(InvoiceRuleConfigRepoProc.qdo.editInvTitle, (Object)invoiceRuleConfigDO.getEditInvTitle());
        }
        update.execute();
    }

    public InvoiceRuleConfigRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

