package com.elitesland.fin.domain.param.aptype;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.param.aptype
 * @date 2022/3/11 16:17
 */
@Data
public class ApTypePageParam extends AbstractOrderQueryParam {


    private static final long serialVersionUID = -4322409132220834219L;
    @ApiModelProperty(value = "应付单类型编码")
    private String apTypeCode;

    @ApiModelProperty(value = "应付单类型名称")
    private String apTypeName;

    @ApiModelProperty(value = "是否启用")
    private Boolean enableFlag;

    @ApiModelProperty(value = "是否默认")
    private Boolean defaultFlag;


    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;


}
