/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.recorder;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitesland.fin.application.convert.recorder.RecOrderExConvert;
import com.elitesland.fin.application.facade.dto.writeoff.RecOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.dto.writeoff.RecOrderExDTO;
import com.elitesland.fin.application.facade.param.recorder.FinRecOrderDetailQuery;
import com.elitesland.fin.application.facade.param.recorder.RecOrderDtlExPageParam;
import com.elitesland.fin.application.facade.param.recorder.RecOrderExPageParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderExVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderInfoVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.service.recorder.RecOrderExService;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDtlDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderExDo;
import com.elitesland.fin.domain.entity.recorder.QRecOrderExDtlDo;
import com.elitesland.fin.domain.entity.recorder.RecOrderDtlDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderExDtlDo;
import com.elitesland.fin.repo.writeoff.RecOrderDetailRepoProc;
import com.elitesland.fin.repo.writeoff.RecOrderExRepoProc;
import com.elitesland.fin.utils.BeanConvertUtils;
import com.elitesland.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class RecOrderExServiceImpl
extends BaseServiceImpl
implements RecOrderExService {
    private static final Logger log = LogManager.getLogger(RecOrderExServiceImpl.class);
    final QRecOrderExDo qRecOrderExDo = QRecOrderExDo.recOrderExDo;
    final QRecOrderExDtlDo qRecOrderExDtlDo = QRecOrderExDtlDo.recOrderExDtlDo;
    final QRecOrderDO recOrderDO = QRecOrderDO.recOrderDO;
    final QRecOrderDtlDO qRecOrderDtlDO = QRecOrderDtlDO.recOrderDtlDO;
    final JPAQueryFactory jpaQueryFactory;
    final OrgRpcService orgRpcService;
    final SysCurrencyRpcService sysCurrencyRpcService;
    final RecOrderDetailRepoProc recOrderDetailRepoProc;
    final EmployeeRpcService employeeRpcService;
    final RecOrderExRepoProc recOrderExRepoProc;
    private RecOrderService recOrderService;

    @Autowired
    @Lazy
    public void setRecOrderService(RecOrderService recOrderService) {
        this.recOrderService = recOrderService;
    }

    @Override
    @SysCodeProc
    public PagingVO<RecOrderExVo> getPage(RecOrderExPageParam recOrderExPageParam) {
        Integer size = recOrderExPageParam.size;
        Integer current = recOrderExPageParam.current;
        recOrderExPageParam.size = Integer.MAX_VALUE;
        recOrderExPageParam.current = 1;
        PagingVO<RecOrderExVo> page = this.recOrderExRepoProc.page(recOrderExPageParam);
        if (page.isEmpty()) {
            return page;
        }
        this.setPageInfo(page);
        if (Boolean.TRUE.equals(recOrderExPageParam.getHeadFlag())) {
            List records = page.getRecords();
            if (CollectionUtils.isEmpty(records = records.stream().filter(item -> BigDecimal.ZERO.compareTo(item.getUnVerAmt()) != 0).collect(Collectors.toList()))) {
                return PagingVO.empty();
            }
            recOrderExPageParam.size = size;
            recOrderExPageParam.current = current;
            recOrderExPageParam.setIds(records.stream().map(RecOrderVO::getId).collect(Collectors.toList()));
            page = this.recOrderExRepoProc.page(recOrderExPageParam);
            this.setPageInfo(page);
        }
        return page;
    }

    public void setPageInfo(PagingVO<RecOrderExVo> page) {
        HashSet<String> buCodes = new HashSet<String>(8);
        HashSet<String> custCodes = new HashSet<String>(8);
        HashSet<String> currCodes = new HashSet<String>(8);
        HashSet<String> saleUserCodes = new HashSet<String>(8);
        HashSet<Long> masIds = new HashSet<Long>(8);
        this.setCode(page, buCodes, custCodes, currCodes, saleUserCodes, masIds);
        List<RecOrderExDtlDo> recOrderExDtlDoList = this.recOrderDetailRepoProc.listByMasIds(masIds);
        List<SysOrgBasicDTO> orgList = this.getOrgList(buCodes);
        List<LmSaveCustRespVO> custResult = this.getCustList(custCodes);
        List<SysCurrencyRespDTO> currList = this.getCurrList(currCodes);
        List<SysEmployeeBasicDTO> employeeList = this.getEmployeeList(saleUserCodes);
        page.getRecords().forEach(recOrderExVo -> {
            recOrderExVo.setRecTypeName("\u6536\u6b3e\u5355");
            try {
                if (!CollectionUtils.isEmpty((Collection)orgList)) {
                    orgList.stream().filter(fi -> fi.getCode().equals(recOrderExVo.getBuCode())).findFirst().ifPresent(opt -> recOrderExVo.setBuName(opt.getName()));
                    orgList.stream().filter(fi -> fi.getCode().equals(recOrderExVo.getRecOuCode())).findFirst().ifPresent(opt -> recOrderExVo.setRecOuName(opt.getName()));
                }
                if (!CollectionUtils.isEmpty((Collection)custResult)) {
                    custResult.stream().filter(fi -> fi.getCustCode().equals(recOrderExVo.getCustCode())).findFirst().ifPresent(opt -> recOrderExVo.setCustomName(opt.getCustName()));
                }
                if (!CollectionUtils.isEmpty((Collection)currList)) {
                    currList.stream().filter(fi -> fi.getCurrCode().equals(recOrderExVo.getCurrCode())).findFirst().ifPresent(opt -> recOrderExVo.setCurrName(opt.getCurrName()));
                }
                if (!CollectionUtils.isEmpty((Collection)employeeList)) {
                    employeeList.stream().filter(fi -> fi.getCode().equals(recOrderExVo.getSaleUser())).findFirst().ifPresent(opt -> recOrderExVo.setBusinessName(opt.getLastName()));
                }
                List extDList = recOrderExDtlDoList.stream().filter(fi -> fi.getMasId().equals(recOrderExVo.getExtId())).collect(Collectors.toList());
                BigDecimal verAmt = BigDecimal.ZERO;
                BigDecimal verAmting = BigDecimal.ZERO;
                BigDecimal unVerAmt = BigDecimal.ZERO;
                if (CollUtil.isNotEmpty(extDList)) {
                    for (RecOrderExDtlDo recOrderExDtlDo : extDList) {
                        verAmt = verAmt.add(recOrderExDtlDo.getVerAmt());
                        verAmting = verAmting.add(recOrderExDtlDo.getApplyVerAmTing());
                        unVerAmt = unVerAmt.add(recOrderExDtlDo.getUnVerAmt());
                    }
                }
                recOrderExVo.setVerAmt(verAmt);
                recOrderExVo.setApplyVerAmTing(verAmting);
                recOrderExVo.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(recOrderExVo.getTotalAmt()) == 0) {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void setCode(PagingVO<RecOrderExVo> page, Set<String> buCodes, Set<String> custCodes, Set<String> currCodes, Set<String> saleUserCodes, Set<Long> masIds) {
        for (RecOrderExVo vo : page.getRecords()) {
            buCodes.add(vo.getOuCode());
            buCodes.add(vo.getBuCode());
            custCodes.add(vo.getCustCode());
            currCodes.add(vo.getCurrCode());
            saleUserCodes.add(vo.getSaleUser());
            masIds.add(vo.getExtId());
        }
    }

    private List<SysCurrencyRespDTO> getCurrList(Set<String> currCodes) {
        ApiResult currResult = this.sysCurrencyRpcService.listByCodes(currCodes);
        if (currResult.isFailed()) {
            throw new BusinessException("\u83b7\u53d6\u5e01\u79cd\u4fe1\u606f\u5931\u8d25");
        }
        return (List)currResult.getData();
    }

    private List<SysEmployeeBasicDTO> getEmployeeList(Set<String> saleUserCodes) {
        EmployeeQueryDTO eeQuery = new EmployeeQueryDTO();
        eeQuery.setCodes(saleUserCodes);
        ApiResult eeResult = this.employeeRpcService.queryList(eeQuery);
        if (eeResult.isFailed()) {
            throw new BusinessException("\u83b7\u53d6\u4e1a\u52a1\u5458\u4fe1\u606f\u5931\u8d25");
        }
        return (List)eeResult.getData();
    }

    private List<LmSaveCustRespVO> getCustList(Set<String> custCodes) {
        CustCode2BaseParam custQuery = new CustCode2BaseParam();
        custQuery.setCustCode(new ArrayList<String>(custCodes));
        return null;
    }

    private List<SysOrgBasicDTO> getOrgList(Set<String> buCodes) {
        SysOrgQueryDTO orgQuery = new SysOrgQueryDTO();
        orgQuery.setCodes(buCodes);
        ApiResult orgResult = this.orgRpcService.queryList(orgQuery);
        if (orgResult.isFailed()) {
            throw new BusinessException("\u83b7\u53d6\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
        }
        return (List)orgResult.getData();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qRecOrderExDo.id, this.qRecOrderExDo.invoiceNumber, this.qRecOrderExDo.relateId, this.qRecOrderExDo.redFlushSign, this.qRecOrderExDo.thirdPaymentAssistance, this.qRecOrderExDo.consumerCardSsistance, this.qRecOrderExDo.creditCardAssistance, this.qRecOrderExDo.payType, this.qRecOrderExDo.recBank, this.qRecOrderExDo.payBank, this.qRecOrderExDo.deleteFlag, this.qRecOrderExDo.tenantId, this.qRecOrderExDo.belongOrgId, this.qRecOrderExDo.tenantOrgId, this.qRecOrderExDo.createTime, this.qRecOrderExDo.updater, this.qRecOrderExDo.modifyTime, this.qRecOrderExDo.creator, this.qRecOrderExDo.remark})).from((EntityPath)this.qRecOrderExDo)).leftJoin((EntityPath)this.qRecOrderExDtlDo)).on((Predicate)this.qRecOrderExDtlDo.masId.eq(this.qRecOrderExDo.id));
    }

    @Override
    @SysCodeProc
    public PagingVO<RecOrderDtlExVo> getDtlPage(RecOrderDtlExPageParam recOrderDtlExPageParam) {
        PagingVO<RecOrderDtlExVo> page = this.recOrderDetailRepoProc.getDtlPage(recOrderDtlExPageParam);
        if (page.isEmpty()) {
            return page;
        }
        this.setInfo(page);
        return page;
    }

    public void setInfo(PagingVO<RecOrderDtlExVo> page) {
        HashSet<String> buCodes = new HashSet<String>(8);
        HashSet<String> custCodes = new HashSet<String>(8);
        HashSet<String> currCodes = new HashSet<String>(8);
        HashSet<String> saleUserCodes = new HashSet<String>(8);
        this.setCode(page, buCodes, custCodes, currCodes, saleUserCodes);
        List<SysOrgBasicDTO> orgList = this.getOrgList(buCodes);
        List<LmSaveCustRespVO> custResult = this.getCustList(custCodes);
        List<SysCurrencyRespDTO> currList = this.getCurrList(currCodes);
        List<SysEmployeeBasicDTO> employeeList = this.getEmployeeList(saleUserCodes);
        page.getRecords().forEach(recOrderDtlExVo -> {
            recOrderDtlExVo.setRecTypeName("\u6536\u6b3e\u5355");
            try {
                if (!CollectionUtils.isEmpty((Collection)orgList)) {
                    orgList.stream().filter(fi -> fi.getCode().equals(recOrderDtlExVo.getBuCode())).findFirst().ifPresent(opt -> recOrderDtlExVo.setBuName(opt.getName()));
                    orgList.stream().filter(fi -> fi.getCode().equals(recOrderDtlExVo.getRecOuCode())).findFirst().ifPresent(opt -> recOrderDtlExVo.setRecOuName(opt.getName()));
                }
                if (!CollectionUtils.isEmpty((Collection)custResult)) {
                    custResult.stream().filter(fi -> fi.getCustCode().equals(recOrderDtlExVo.getCustCode())).findFirst().ifPresent(opt -> recOrderDtlExVo.setCustName(opt.getCustName()));
                }
                if (!CollectionUtils.isEmpty((Collection)currList)) {
                    currList.stream().filter(fi -> fi.getCurrCode().equals(recOrderDtlExVo.getCurrCode())).findFirst().ifPresent(opt -> recOrderDtlExVo.setCurrName(opt.getCurrName()));
                }
                if (!CollectionUtils.isEmpty((Collection)employeeList)) {
                    employeeList.stream().filter(fi -> fi.getCode().equals(recOrderDtlExVo.getBusinessCode())).findFirst().ifPresent(opt -> recOrderDtlExVo.setBusinessName(opt.getLastName()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void setCode(PagingVO<RecOrderDtlExVo> page, Set<String> buCodes, Set<String> custCodes, Set<String> currCodes, Set<String> saleUserCodes) {
        for (RecOrderDtlExVo vo : page.getRecords()) {
            buCodes.add(vo.getRecOuCode());
            buCodes.add(vo.getBuCode());
            custCodes.add(vo.getCustCode());
            currCodes.add(vo.getCurrCode());
            saleUserCodes.add(vo.getBusinessCode());
        }
    }

    @Override
    public RecOrderExVo getDetailExInfo(RecOrderVO recOrderVO) {
        RecOrderExDTO arOrderExDTO = (RecOrderExDTO)this.select(RecOrderExDTO.class).fetchOne();
        RecOrderExVo recOrderExVo = new RecOrderExVo();
        if (ObjectUtil.isNotNull((Object)arOrderExDTO)) {
            RecOrderExVo arOrderExVo1 = RecOrderExConvert.INSTANCE.qeryDto2Vo(arOrderExDTO);
            RecOrderExVo arOrderExVo2 = RecOrderExConvert.INSTANCE.Vo2ExVo(recOrderVO);
            recOrderExVo = (RecOrderExVo)BeanConvertUtils.beanConvert(arOrderExVo1, arOrderExVo2);
            log.info("\u8f6c\u6362\u4e4b\u540e\u7684\u7c7b\uff0crecOrderExVo:{}", (Object)JSONUtil.toJsonStr((Object)recOrderExVo));
            try {
                SysOrgBasicDTO data = (SysOrgBasicDTO)this.orgRpcService.getByCode(recOrderExVo.getBuCode()).getData();
                recOrderExVo.setBuName(data == null ? "" : data.getName());
                Object data1 = null;
                recOrderExVo.setCustomName(data1 == null ? "" : data1.getCustName());
                SysOrgBasicDTO data2 = (SysOrgBasicDTO)this.orgRpcService.getByCode(recOrderExVo.getRecOuCode()).getData();
                recOrderExVo.setRecOuName(data2 == null ? "" : data2.getName());
                SysCurrencyRespDTO data3 = (SysCurrencyRespDTO)this.sysCurrencyRpcService.getByCode(recOrderExVo.getCurrCode()).getData();
                recOrderExVo.setCurrName(data3 == null ? "" : data3.getCurrName());
                SysEmployeeBasicDTO data4 = (SysEmployeeBasicDTO)this.employeeRpcService.getByCode(recOrderExVo.getSaleUser()).getData();
                recOrderExVo.setBusinessName(data4 == null ? "" : data4.getLastName());
                recOrderExVo.setRecTypeName("\u6536\u6b3e\u5355");
                List<Long> masIds = Arrays.asList(arOrderExDTO.getId());
                List<RecOrderExDtlDo> recOrderExDtlDos = this.recOrderDetailRepoProc.listByMasIds(masIds);
                List extDList = recOrderExDtlDos.stream().filter(fi -> fi.getMasId().equals(arOrderExDTO.getId())).collect(Collectors.toList());
                BigDecimal verAmt = BigDecimal.ZERO;
                BigDecimal verAmting = BigDecimal.ZERO;
                BigDecimal unVerAmt = BigDecimal.ZERO;
                if (CollUtil.isNotEmpty(extDList)) {
                    for (RecOrderExDtlDo recOrderExDtlDo : extDList) {
                        verAmt = verAmt.add(recOrderExDtlDo.getVerAmt());
                        verAmting = verAmting.add(recOrderExDtlDo.getApplyVerAmTing());
                        unVerAmt = unVerAmt.add(recOrderExDtlDo.getUnVerAmt());
                    }
                }
                recOrderExVo.setVerAmt(verAmt);
                recOrderExVo.setApplyVerAmTing(verAmting);
                recOrderExVo.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(recOrderExVo.getTotalAmt()) == 0) {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recOrderExVo;
    }

    @Override
    public List<RecOrderDtlExVo> listRecOrderDetail(FinRecOrderDetailQuery query) {
        return this.recOrderDetailRepoProc.listRecOrderDetail(query);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long recDId, BigDecimal amt, String verType) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMiddleVerAmt(Long recDId, BigDecimal amt) {
        RecOrderDtlDO detail = this.findDetail(recDId);
        this.doUpdateVerAmt(this.getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }

    @Override
    public ApiResult<RecOrderInfoVo> info(Long id) {
        RecOrderInfoVo vo = new RecOrderInfoVo();
        RecOrderVO recOrderVO = this.recOrderService.queryById(id);
        if (ObjectUtil.isNull((Object)recOrderVO)) {
            throw new BusinessException("\u67e5\u8be2\u6536\u6b3e\u5355\u4e3b\u8868\u6570\u636e\u4fe1\u606f\u4e3a\u7a7a");
        }
        BeanUtil.copyProperties((Object)recOrderVO, (Object)vo, (String[])new String[0]);
        this.handleRecOrderCode2Name(vo);
        RecOrderExDTO arOrderExDTO = (RecOrderExDTO)this.select(RecOrderExDTO.class).fetchOne();
        if (ObjectUtil.isNotNull((Object)arOrderExDTO)) {
            vo.setInvoiceNumber(arOrderExDTO.getInvoiceNumber());
            vo.setRedFlushSign(arOrderExDTO.getRedFlushSign());
            vo.setThirdPaymentAssistance(arOrderExDTO.getThirdPaymentAssistance());
            vo.setConsumerCardSsistance(arOrderExDTO.getConsumerCardSsistance());
            vo.setCreditCardAssistance(arOrderExDTO.getCreditCardAssistance());
            vo.setPayType(arOrderExDTO.getPayType());
            vo.setRecBank(arOrderExDTO.getRecBank());
            vo.setPayBank(arOrderExDTO.getPayBank());
            vo.setExtId(arOrderExDTO.getId());
            this.handleRecOrderDtl(vo);
        }
        return ApiResult.ok((Object)vo);
    }

    private void handleRecOrderCode2Name(RecOrderInfoVo vo) {
        vo.setRecTypeName("\u6536\u6b3e\u5355");
        try {
            SysOrgBasicDTO data = (SysOrgBasicDTO)this.orgRpcService.getByCode(vo.getBuCode()).getData();
            vo.setBuName(data == null ? "" : data.getName());
        }
        catch (Exception e) {
            log.error("\u9500\u552e\u7ec4\u7ec7code2Name\u8f6c\u6362\u5f02\u5e38", (Object)JSONUtil.toJsonStr((Object)vo), (Object)e.getMessage());
        }
        try {
            Object data1 = null;
            vo.setCustomName(data1 == null ? "" : data1.getCustName());
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u540d\u79f0code2Name\u8f6c\u6362\u5f02\u5e38", (Object)JSONUtil.toJsonStr((Object)vo), (Object)e.getMessage());
        }
        try {
            SysOrgBasicDTO data2 = (SysOrgBasicDTO)this.orgRpcService.getByCode(vo.getRecOuCode()).getData();
            vo.setRecOuName(data2 == null ? "" : data2.getName());
        }
        catch (Exception e) {
            log.error("\u6536\u6b3e\u516c\u53f8\u540d\u79f0code2Name\u8f6c\u6362\u5f02\u5e38", (Object)JSONUtil.toJsonStr((Object)vo), (Object)e.getMessage());
        }
        try {
            SysCurrencyRespDTO data3 = (SysCurrencyRespDTO)this.sysCurrencyRpcService.getByCode(vo.getCurrCode()).getData();
            vo.setCurrName(data3 == null ? "" : data3.getCurrName());
        }
        catch (Exception e) {
            log.error("\u5e01\u79cd\u540d\u79f0code2Name\u8f6c\u6362\u5f02\u5e38", (Object)JSONUtil.toJsonStr((Object)vo), (Object)e.getMessage());
        }
        try {
            SysEmployeeBasicDTO data4 = (SysEmployeeBasicDTO)this.employeeRpcService.getByCode(vo.getSaleUser()).getData();
            vo.setBusinessName(data4 == null ? "" : data4.getLastName());
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5458\u540d\u79f0code2Name\u8f6c\u6362\u5f02\u5e38", (Object)JSONUtil.toJsonStr((Object)vo), (Object)e.getMessage());
        }
    }

    private void handleRecOrderDtl(RecOrderInfoVo vo) {
        List<RecOrderExDtlDo> dtlDos = this.recOrderDetailRepoProc.listByMasIds(Arrays.asList(vo.getExtId()));
        log.info("\u6839\u636e\u6536\u6b3e\u5355\u4e3b\u8868id\u83b7\u53d6\u6536\u6b3e\u5355\u660e\u7ec6\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr(dtlDos));
        if (CollUtil.isEmpty(dtlDos)) {
            log.error("\u6839\u636e\u6536\u6b3e\u5355\u4e3b\u8868id\u83b7\u53d6\u6536\u6b3e\u5355\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a\uff0c", (Object)JSONUtil.toJsonStr((Object)vo));
            return;
        }
        BigDecimal verAmt = BigDecimal.ZERO;
        BigDecimal verAmting = BigDecimal.ZERO;
        BigDecimal unVerAmt = BigDecimal.ZERO;
        for (RecOrderExDtlDo recOrderExDtlDo : dtlDos) {
            verAmt = verAmt.add(recOrderExDtlDo.getVerAmt());
            verAmting = verAmting.add(recOrderExDtlDo.getApplyVerAmTing());
            unVerAmt = unVerAmt.add(recOrderExDtlDo.getUnVerAmt());
        }
        vo.setVerAmt(verAmt);
        vo.setApplyVerAmTing(verAmting);
        vo.setUnVerAmt(unVerAmt);
        if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
            vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            vo.setVerStateName(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCodeName());
        } else if (unVerAmt.add(verAmting).compareTo(vo.getTotalAmt()) == 0) {
            vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            vo.setVerStateName(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCodeName());
        } else {
            vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            vo.setVerStateName(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCodeName());
        }
    }

    private RecOrderDtlDO findDetail(Long recDId) {
        RecOrderDtlDO detail = this.recOrderDetailRepoProc.getExtRecOrderDetailAmt(recDId);
        Assert.notNull((Object)detail, (String)("\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u5355\u660e\u7ec6\uff0c\u660e\u7ec6ID:" + recDId));
        return detail;
    }

    private void doUpdateVerAmt(RecOrderAmtUpdateDTO update) {
        if (this.recOrderDetailRepoProc.updateExtVerAmt(update) == 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @NotNull
    private RecOrderAmtUpdateDTO.RecOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, RecOrderDtlDO detail) {
        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);
        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return RecOrderAmtUpdateDTO.builder().arDId(detail.getId()).unVerAmt(unVerAmt).verAmting(verAmting).verAmt(detail.getVerAmt()).version(detail.getAuditDataVersion());
    }

    @NotNull
    private RecOrderAmtUpdateDTO.RecOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, RecOrderExDtlDo detail, String verType) {
        String infoStr = JSONUtil.toJsonStr((Object)detail);
        log.info("\u8ba1\u7b97\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d,{}-{}", (Object)amt, (Object)infoStr);
        if ("2".equals(verType)) {
            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("\u53d6\u6d88\u6838\u9500,{}-{}-{}", (Object)infoStr, (Object)verAmt, (Object)unVerAmt);
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
            }
            return RecOrderAmtUpdateDTO.builder().arDId(detail.getExtId()).unVerAmt(unVerAmt).verAmting(detail.getApplyVerAmTing()).verAmt(verAmt).version(detail.getVersion());
        }
        BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
        BigDecimal verAmt = detail.getVerAmt().add(amt);
        log.info("\u6838\u9500\u901a\u8fc7,{}-{}-{}", (Object)infoStr, (Object)verAmting, (Object)verAmt);
        if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return RecOrderAmtUpdateDTO.builder().arDId(detail.getExtId()).unVerAmt(detail.getUnVerAmt()).verAmting(verAmting).verAmt(verAmt).version(detail.getVersion());
    }

    private <T> JPAQuery<T> selectDtEx(Class<T> cls) {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qRecOrderExDtlDo.id, this.qRecOrderExDtlDo.relateId, this.qRecOrderExDtlDo.thirdOrderDtId, this.qRecOrderExDtlDo.currCode, this.qRecOrderExDtlDo.custCode, this.qRecOrderExDtlDo.naturePayment, this.qRecOrderExDtlDo.buCode, this.qRecOrderExDtlDo.recBank, this.qRecOrderExDtlDo.payBank, this.qRecOrderExDtlDo.businessCode, this.qRecOrderExDtlDo.exchangeRate, this.qRecOrderExDtlDo.deleteFlag, this.qRecOrderExDtlDo.tenantId, this.qRecOrderExDtlDo.belongOrgId, this.qRecOrderExDtlDo.tenantOrgId, this.qRecOrderExDtlDo.createTime, this.qRecOrderExDtlDo.updater, this.qRecOrderExDtlDo.modifyTime, this.qRecOrderExDtlDo.creator, this.qRecOrderExDtlDo.remark, this.qRecOrderExDtlDo.unVerAmt, this.qRecOrderExDtlDo.applyVerAmTing, this.qRecOrderExDtlDo.verAmt, this.recOrderDO.recOuCode, this.qRecOrderExDo.invoiceNumber, this.qRecOrderDtlDO.recKind, this.qRecOrderDtlDO.id.as("recDId"), this.recOrderDO.sourceNo, this.recOrderDO.id.as("recOrderId"), this.recOrderDO.recOrderNo})).from((EntityPath)this.qRecOrderExDtlDo)).leftJoin((EntityPath)this.qRecOrderExDo)).on((Predicate)this.qRecOrderExDtlDo.masId.eq(this.qRecOrderExDo.id));
    }

    private void checkParam(RecOrderExPageParam recOrderExPageParam, List<Predicate> predicates) {
        if (StringUtils.isNotBlank((CharSequence)recOrderExPageParam.getRecOrderNo())) {
            predicates.add((Predicate)this.recOrderDO.recOrderNo.like("%" + recOrderExPageParam.getRecOrderNo() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)recOrderExPageParam.getRecOuCode())) {
            predicates.add((Predicate)this.recOrderDO.recOuCode.eq((Object)recOrderExPageParam.getRecOuCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)recOrderExPageParam.getBuCode())) {
            predicates.add((Predicate)this.recOrderDO.buCode.eq((Object)recOrderExPageParam.getBuCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)recOrderExPageParam.getCustCode())) {
            predicates.add((Predicate)this.recOrderDO.custCode.eq((Object)recOrderExPageParam.getCustCode()));
        }
        if (null != recOrderExPageParam.getTotalAmtFrom() || null != recOrderExPageParam.getTotalAmtTo()) {
            predicates.add((Predicate)this.recOrderDO.totalAmt.between((Number)recOrderExPageParam.getTotalAmtFrom(), (Number)recOrderExPageParam.getTotalAmtTo()));
        }
        if (StringUtils.isNotBlank((CharSequence)recOrderExPageParam.getSourceNo())) {
            predicates.add((Predicate)this.recOrderDO.sourceNo.like("%" + recOrderExPageParam.getSourceNo() + "%"));
        }
        if (null != recOrderExPageParam.getCreateTimeStart() || null != recOrderExPageParam.getCreateTimeEnd()) {
            predicates.add((Predicate)this.qRecOrderExDo.createTime.between((Comparable)recOrderExPageParam.getCreateTimeStart(), (Comparable)recOrderExPageParam.getCreateTimeEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)recOrderExPageParam.getBusinessCode())) {
            predicates.add((Predicate)this.qRecOrderExDtlDo.businessCode.eq((Object)recOrderExPageParam.getBusinessCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)recOrderExPageParam.getInvoiceNumber())) {
            predicates.add((Predicate)this.qRecOrderExDo.invoiceNumber.eq((Object)recOrderExPageParam.getInvoiceNumber()));
        }
        if (null != recOrderExPageParam.getCreateTimeStart() || null != recOrderExPageParam.getCreateTimeEnd()) {
            predicates.add((Predicate)this.qRecOrderExDo.createTime.between((Comparable)recOrderExPageParam.getCreateTimeStart(), (Comparable)recOrderExPageParam.getCreateTimeEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)recOrderExPageParam.getRemark())) {
            predicates.add((Predicate)this.qRecOrderExDo.remark.eq((Object)recOrderExPageParam.getRemark()));
        }
        if (recOrderExPageParam.getRedFlushSign() != null) {
            predicates.add((Predicate)this.qRecOrderExDo.redFlushSign.eq(recOrderExPageParam.getRedFlushSign()));
        }
        if (recOrderExPageParam.getInitFlag() != null) {
            predicates.add((Predicate)this.recOrderDO.initFlag.eq(recOrderExPageParam.getInitFlag()));
        }
    }

    public RecOrderExServiceImpl(JPAQueryFactory jpaQueryFactory, OrgRpcService orgRpcService, SysCurrencyRpcService sysCurrencyRpcService, RecOrderDetailRepoProc recOrderDetailRepoProc, EmployeeRpcService employeeRpcService, RecOrderExRepoProc recOrderExRepoProc) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.orgRpcService = orgRpcService;
        this.sysCurrencyRpcService = sysCurrencyRpcService;
        this.recOrderDetailRepoProc = recOrderDetailRepoProc;
        this.employeeRpcService = employeeRpcService;
        this.recOrderExRepoProc = recOrderExRepoProc;
    }
}

