package com.elitesland.fin.application.facade.dto.payment;

import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Data
public class PaymentRuleConfigDtlDTO extends BaseModelDTO implements Serializable {
    private static final long serialVersionUID = -6636051829799954013L;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "优先级")
    private Integer priorityNo;

    @ApiModelProperty("扣款单据状态")
    private String optDocStatus;

    @ApiModelProperty("扣款单据类型")
    private String optDocType;

    @ApiModelProperty("扣款账户类型")
    private String optAccountType;

    @ApiModelProperty("最高扣款比例")
    private BigDecimal calculatePercent;

//    @ApiModelProperty("扣款单据类型")
//    private String docType;
//
//    @ApiModelProperty("扣款单据状态")
//    private String docStatus;
//
//    @ApiModelProperty("扣款账户类型")
//    private String accountType;

    //rpc

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户类型")
    private String accountType;
    private String accountTypeName;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("可用金额")
    private BigDecimal availableAmount;

    @ApiModelProperty("订单可用金额")
    private BigDecimal orderAvailableAmount;

    @ApiModelProperty("时间")
    private LocalDateTime time;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("订单可用支付金额")
    private BigDecimal orderTotalAvailableAmount;

    @ApiModelProperty("可开票金额")
    private BigDecimal invoiceAmount;

    @ApiModelProperty("支付金额")
    private BigDecimal paymentAmount;

    @ApiModelProperty("参与计算标识")
    private boolean calculateFlag;

    @ApiModelProperty("适用单据")
    private String optDoc;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    private String status;

    @ApiModelProperty("账户信息")
    private AccountDTO accountDTO;

    @ApiModelProperty("信用账户信息")
    private CreditAccountDTO creditAccountDTO;

    @ApiModelProperty("货款")
    private BigDecimal itemFee;

    @ApiModelProperty("科技费")
    private BigDecimal techFee;

    @ApiModelProperty("营销费")
    private BigDecimal marketingFee;

    @ApiModelProperty("运营费")
    private BigDecimal operationFee;
}