package com.elitesland.fin.application.facade.excel.convert;

import com.elitesland.fin.utils.excel.convert.Converter;
import org.apache.commons.lang3.StringUtils;

public class StringToBooleanConverter extends Converter<String, Boolean, Void> {
    @Override
    public Boolean convert(String value) {
        if(StringUtils.isBlank(value)) {
            return null;
        }
        if(value.equals("1") || value.equalsIgnoreCase("true")) {
            return true;
        }
        
        if(value.equals("0") || value.equalsIgnoreCase("false")) {
            return false;
        }
        return null;
    }
}
