package com.elitesland.fin.application.facade.vo.expense;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDtlDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * @author Mark
 * @date 2024/08/13 14:23
 */
@Data
@ApiModel("详情传输类")
public class ExpRuleConfigQueryVO extends BaseModelVO implements Serializable {

    @ApiModelProperty(value = "优先级")
    private Integer priorityNo;

    @ApiModelProperty("账户规则码")
    private String ruleCode;

    @ApiModelProperty("账户规则名称")
    private String ruleName;

    @ApiModelProperty("费用类型编码")
    private String expTypeCode;

    @ApiModelProperty("费用类型名称")
    private String expTypeName;

    @ApiModelProperty("是否启用")
    private Boolean enableFlag;

    @ApiModelProperty("计算方式 1固定金额/2固定比例")
    @SysCode(sys = "yst-fin", mod = "CAL_TYPE")
    private String calculateType;
    private String calculateTypeName;

    @ApiModelProperty("计费元素")
    private String expElement;

    @ApiModelProperty("计费元素 中文翻译")
    private String expElementName;

    @ApiModelProperty("计算比例")
    private BigDecimal calculatePercent;

    @ApiModelProperty("计算比例金额来源")
    @SysCode(sys = "yst-fin", mod = "CAL_SRC")
    private String calculatePercentSrc;

    @ApiModelProperty("计算比例金额来源名称")
    private String calculatePercentSrcName;

    @ApiModelProperty("单位金额")
    private BigDecimal uomAmt;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;

    @ApiModelProperty("单位名称")
    private String uomName;

    @ApiModelProperty(value = "台账自动审核 1-是 0-否")
    private boolean automaticReview;

    @ApiModelProperty("生效日期")
    private LocalDate validDate;

    public List<ExpRuleConfigDtlDTO> expRuleConfigDtlDTOList;
}