package com.elitesland.fin.application.web.paymentperiod;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementComPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementComPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.application.service.paymentperiod.ReceiptPaymentAgreementDtlService;
import com.elitesland.fin.application.service.paymentperiod.ReceiptPaymentAgreementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/fin/receiptPaymentAgreement")
@RequiredArgsConstructor
@Api(value = "收付款协议设置", tags = {"收付款协议设置"})
public class ReceiptPaymentAgreementController {

    private final ReceiptPaymentAgreementService receiptPaymentAgreementService;

    private final ReceiptPaymentAgreementDtlService receiptPaymentAgreementDtlService;


    @PostMapping("save")
    @ApiOperation("新增-收付款协议")
    public ApiResult<Long> save(@RequestBody ReceiptPaymentAgreementSaveParam saveParam) {
        Long id = receiptPaymentAgreementService.save(saveParam);
        return ApiResult.ok(id);
    }

   /* @PostMapping("update")
    @ApiOperation("修改-收付款协议")
    public ApiResult<Long> update(@RequestBody ReceiptPaymentAgreementSaveParam saveParam) {
        Long id = receiptPaymentAgreementService.update(saveParam);
        return ApiResult.ok(id);
    }*/

    @PostMapping("/page")
    @ApiOperation("收付款协议分页查询")
    public ApiResult<PagingVO<ReceiptPaymentAgreementPagingVO>> page(@RequestBody ReceiptPaymentAgreementPageParam pageParam) {
        PagingVO<ReceiptPaymentAgreementPagingVO> page = receiptPaymentAgreementService.page(pageParam);
        return ApiResult.ok(page);
    }

    @GetMapping("/findIdOne/{id}")
    @ApiOperation("根据收付款协议ID查询收付款协议详情数据")
    public ApiResult<ReceiptPaymentAgreementVO> findIdOne(@PathVariable Long id) {
        ReceiptPaymentAgreementVO agreementVO = receiptPaymentAgreementService.findIdOne(id);
        return ApiResult.ok(agreementVO);
    }

    @GetMapping("/findCodeOne/{code}")
    @ApiOperation("根据收付款协议编码查询收付款协议详情数据")
    public ApiResult<ReceiptPaymentAgreementVO> findCodeOne(@PathVariable String code) {
        ReceiptPaymentAgreementVO agreementVO = receiptPaymentAgreementService.findCodeOne(code);
        return ApiResult.ok(agreementVO);
    }

    @DeleteMapping("/deleteBatch")
    @ApiOperation("根据收付款协议ID批量删除")
    public ApiResult<List<Long>> deleteBatch(@RequestBody List<Long> ids) {
        receiptPaymentAgreementService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @PostMapping("/enable")
    @ApiOperation("根据收付款协议ID批量启用")
    public ApiResult<List<Long>> enableBatch(@RequestBody List<Long> ids) {
        receiptPaymentAgreementService.enableBatch(ids);
        return ApiResult.ok();
    }

    @PostMapping("/disable")
    @ApiOperation("根据收付款协议ID批量停用")
    public ApiResult<List<Long>> disableBatch(@RequestBody List<Long> ids) {
        receiptPaymentAgreementService.disableBatch(ids);
        return ApiResult.ok();
    }


    @PostMapping("/common/page")
    @ApiOperation("收付款协议公共分页查询")
    public ApiResult<PagingVO<ReceiptPaymentAgreementComPagingVO>> commonPage(@RequestBody ReceiptPaymentAgreementComPageParam pageParam) {
        PagingVO<ReceiptPaymentAgreementComPagingVO> page = receiptPaymentAgreementService.commonPage(pageParam);
        return ApiResult.ok(page);
    }

    /*@PostMapping("/receipt/common/page")
    @ApiOperation("收款协议公共分页查询")
    public ApiResult<PagingVO<ReceiptPaymentAgreementComPagingVO>> receiptCommonPage(@RequestBody ReceiptPaymentAgreementComPageParam pageParam) {
        PagingVO<ReceiptPaymentAgreementComPagingVO> page = receiptPaymentAgreementService.receiptCommonPage(pageParam);
        return ApiResult.ok(page);
    }

    @PostMapping("/payment/common/page")
    @ApiOperation("付款协议公共分页查询")
    public ApiResult<PagingVO<ReceiptPaymentAgreementComPagingVO>> paymentCommonPage(@RequestBody ReceiptPaymentAgreementComPageParam pageParam) {
        PagingVO<ReceiptPaymentAgreementComPagingVO> page = receiptPaymentAgreementService.paymentCommonPage(pageParam);
        return ApiResult.ok(page);
    }*/

}
