package com.elitesland.fin.domain.service.aporder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.param.aporder.ApOrderParam;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.workflow.ProcessInfo;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.aporder
 * @date 2022/3/16 10:45
 */
public interface ApOrderDomainService {

    Long save(ApOrder apOrder);

    PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam);

    ApOrderDTO get(Long id);

    List<ApOrderDTO> get(List<Long> ids);

    Long audit(List<Long> ids, String content, SysUserDTO user);

    void delByApOrderNoOrSourceNos(List<String> sourceNos,String sourceType);

    Long del(List<Long> ids);

    Long delOnly(List<Long> ids);

    Long commit(ApOrder apOrder);

    Long newCommit(ApOrder apOrder);

    ApOrderDTO getApOrderAndDtl(Long id);

    List<ApOrderDTO> queryByIds(List<Long> ids);

    List<ApOrderDTO> getApOrderList(ApOrderParam apOrderParam);

    List<ApOrderDTO> selectApOrderByParam(ApOrderParam apOrderParam);

    Boolean queryByApTypeId(Long apTypeId);

    void updateVerAmt(Long id, BigDecimal amt);

    void updateWorkInfo(ProcessInfo processInfo, Long id);

    void updateSourceNo(String sourceNo, Long id);

    /**
     * 重置单据状态
     * @param ids
     */
    void restDocState(List<Long> ids);

    /**
     * 红冲单据创建
     * @param id
     * @return
     */
    ApOrder redPunchCreate(Long id);
    public PagingVO<ApOrderDTO> writeoffPage(ApOrderPageParam apOrderPageParam);

}
