package com.elitesland.fin.entity.account;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Entity
@Table(name = "account_rule_config_dtl")
@org.hibernate.annotations.Table(appliesTo = "account_rule_config_dtl", comment = "账户规则配置明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
@ApiModel(value = "account_rule_config_dtl", description = "账户规则配置明细")
public class AccountRuleConfigDtlDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -6829086191452645974L;

    @ApiModelProperty(value = "主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表ID'")
    private Long masId;

    @ApiModelProperty(value = "执行序列")
    @Column(name = "priority_no",columnDefinition = "int(6)  comment '执行序列'")
    private Integer priorityNo;

    @ApiModelProperty(value = "事务码")
    @Column(name = "io_code",columnDefinition = "varchar(32)  comment '事务码'")
    private String ioCode;

    @ApiModelProperty("事务码名称")
    @Column(name = "io_name", columnDefinition = "varchar(32)  comment '事务码名称'")
    private String ioName;

    @ApiModelProperty("适用单据类型")
    @Column(name = "opt_doc_type", columnDefinition = "varchar(32)  comment '适用单据类型'")
    private String optDocType;

    @ApiModelProperty("适用单据状态")
    @Column(name = "opt_doc_status", columnDefinition = "varchar(32)  comment '适用单据状态'")
    private String optDocStatus;

    @ApiModelProperty("适用账户类型")
    @Column(name = "opt_account_type", columnDefinition = "varchar(32)  comment '适用账户类型'")
    private String optAccountType;

    @ApiModelProperty("指定账户")
    @Column(name = "specific_account", columnDefinition = "varchar(2000)  comment '指定账户'")
    private String specificAccount;

    @ApiModelProperty("最高透支额度")
    @Column(name = "max_limit", columnDefinition = "decimal(18,8) comment '最高透支额度'")
    private BigDecimal maxLimit;

    @ApiModelProperty("计算比例")
    @Column(name = "calculate_percent", columnDefinition = "decimal(18,2) comment '计算比例'")
    private BigDecimal calculatePercent;

    @ApiModelProperty(value = "流水自动审核 1-是 0-否")
    @Column(name = "automatic_review",columnDefinition = "tinyint(1)  comment '流水自动审核 Y-是 N-否'")
    private boolean automaticReview;
}