package com.elitesland.fin.entity.invoice;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Entity
@Table(name = "fin_payment_records_d")
@org.hibernate.annotations.Table(appliesTo = "fin_payment_records_d", comment = "付款记录明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "付款记录明细表", description = "付款记录明细表")
@Where(clause = "delete_flag = 0")
public class PaymentRecordsDDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表ID'")
    private Long masId;

    @Column(name = "line_no", columnDefinition = "int(11) comment '明细行号'")
    private Integer lineNo;

    @Column(name = "item_code", columnDefinition = "varchar(32) comment '商品编码'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(64) comment '商品名称'")
    private String itemName;

    @Column(name = "tax_type", columnDefinition = "varchar(32) comment '税收分类编码'")
    private String taxType;

    @Column(name = "service_name", columnDefinition = "varchar(32) comment '应税货物或劳务、服务名称'")
    private String serviceName;

    @Column(name = "item_spec", columnDefinition = "varchar(32) comment '规格'")
    private String itemSpec;

    @Column(name = "uom", columnDefinition = "varchar(32) comment '单位'")
    private String uom;

    @Column(name = "qty", columnDefinition = "decimal(18,8) comment '数量'")
    private BigDecimal qty;

    @Column(name = "originAmt", columnDefinition = "decimal(18,8) comment '含税单价'")
    private BigDecimal originAmt;

    @Column(name = "amt", columnDefinition = "DECIMAL(20,8) comment '含税金额'")
    private BigDecimal amt;

    @Column(name = "tax_rate", columnDefinition = "DECIMAL(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "tax", columnDefinition = "DECIMAL(20,8) comment '税额'")
    private BigDecimal tax;

    @Column(name = "net_amt", columnDefinition = "DECIMAL(20,8) comment '不含税金额'")
    private BigDecimal netAmt;

    @Column(name = "payment_status", columnDefinition = "varchar(64) comment '付款状态'")
    private String paymentStatus;

    /**
     * 收费项目(商品code),字段名称暂不做修改
     */
//    @Column(name = "item_code", columnDefinition = "varchar(32) comment '商品code'")
//    private String itemCode;

    @Column(name = "receipt_id", columnDefinition = "bigint(20) comment '收款单ID'")
    private Long receiptId;

    @Column(name = "real_rec_amt", columnDefinition = "DECIMAL(20,8) comment '实收金额'")
    private BigDecimal realRecAmt;

    @Comment(value = "是否参与开票")
    @Column()
    private String isToBilling;

    @Column(name = "trans_price", columnDefinition = "decimal(18,8) comment '含税单价'")
    private BigDecimal transPrice;
}
