package com.elitesland.fin.provider.paymentperiod;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.paymentperiod.ReceiptPaymentAgreementConvert;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementPageParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.dto.paymentperiod.ReceiptPaymentAgreementRpcDTO;
import com.elitesland.fin.dto.receiptpayment.ReceiptPaymentAgreementDTO;
import com.elitesland.fin.param.paymentperiod.ReceiptPaymentAgreementRpcParam;
import com.elitesland.fin.service.paymentperiod.ReceiptPaymentAgreementRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/22
 * @Version 1.0
 * @Content:
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + ReceiptPaymentAgreementRpcService.PATH)
@Slf4j
public class ReceiptPaymentAgreementRpcServiceImpl implements ReceiptPaymentAgreementRpcService {

    public final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;

    @Override
    @SysCodeProc
    public List<ReceiptPaymentAgreementRpcDTO> selectByParam(ReceiptPaymentAgreementRpcParam rpcParam) {

        ReceiptPaymentAgreementPageParam pageParam = ReceiptPaymentAgreementConvert.INSTANCE.rpcParamToParam(rpcParam);
        List<ReceiptPaymentAgreementVO> voList =  receiptPaymentAgreementDomainService.selectByParam(pageParam);
        if (CollectionUtil.isEmpty(voList)){
            return Collections.emptyList();
        }

        List<ReceiptPaymentAgreementRpcDTO> rpcDTOList = voList.stream().map(ReceiptPaymentAgreementConvert.INSTANCE::voToRpcDto).collect(Collectors.toList());

        return rpcDTOList;
    }

    @Override
    @SysCodeProc
    public List<ReceiptPaymentAgreementDTO> selectByParam2(ReceiptPaymentAgreementRpcParam rpcParam) {

        ReceiptPaymentAgreementPageParam pageParam = ReceiptPaymentAgreementConvert.INSTANCE.rpcParamToParam(rpcParam);
        List<ReceiptPaymentAgreementVO> voList =  receiptPaymentAgreementDomainService.selectByParam(pageParam);
        if (CollectionUtil.isEmpty(voList)){
            return Collections.emptyList();
        }
        ArrayList<ReceiptPaymentAgreementDTO> result = new ArrayList<>();
        for (ReceiptPaymentAgreementVO vo : voList) {
            result.add(ReceiptPaymentAgreementDTO.builder()
                            .protocolType(vo.getProtocolType())
                            .protocolTypeName(vo.getProtocolTypeName())
                            .protocolCode(vo.getProtocolCode())
                            .protocolName(vo.getProtocolName())
                    .build());
        }

        return result;
    }

}
