package com.elitesland.fin.repo.invoice;


import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface InvoiceAwaitRepo extends JpaRepository<InvoiceAwaitDO, Long>, QuerydslPredicateExecutor<InvoiceAwaitDO> {
    boolean existsByOptDocNoAndOptDocType(String sourceNo, String sourceType);

    boolean existsByOptDocId(Long id);

    /**
     * 通过来源单据类型查询
     * @param optDocTypes 来源单据类型
     * @return
     */
    List<InvoiceAwaitDO> getAllByOptDocTypeIn(List<String> optDocTypes);
}
