/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.saleinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDetailAppVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvdDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Component;

@Component
public class SaleInvdDtlRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;
    private final QSaleInvDO qSaleInvDO = QSaleInvDO.saleInvDO;

    public List<Long> getMasId(SaleInvPageParam saleInvPageParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getInvNo())) {
            predicates.add(this.qSaleInvdDtlDO.invNo.like("%" + saleInvPageParam.getInvNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getBlueInvNo())) {
            predicates.add(this.qSaleInvdDtlDO.blueInvNo.like("%" + saleInvPageParam.getBlueInvNo() + "%"));
        }
        if (null != saleInvPageParam.getInvDateStart() && null != saleInvPageParam.getInvDateEnd()) {
            predicates.add(this.qSaleInvdDtlDO.invDate.between((Comparable)saleInvPageParam.getInvDateStart(), (Comparable)saleInvPageParam.getInvDateEnd()));
        }
        if (null != saleInvPageParam.getTotalAmtStart()) {
            predicates.add(this.qSaleInvdDtlDO.totalAmt.goe((Number)saleInvPageParam.getTotalAmtStart()));
        }
        if (null != saleInvPageParam.getTotalAmtEnd()) {
            predicates.add(this.qSaleInvdDtlDO.totalAmt.loe((Number)saleInvPageParam.getTotalAmtEnd()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getRedState())) {
            predicates.add(this.qSaleInvdDtlDO.redState.eq((Object)saleInvPageParam.getRedState()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getInvState())) {
            predicates.add(this.qSaleInvdDtlDO.invState.eq((Object)saleInvPageParam.getInvState()));
        }
        predicates.add(this.qSaleInvdDtlDO.deleteFlag.eq((Object)0));
        List ids = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qSaleInvdDtlDO.masId).from((EntityPath)this.qSaleInvdDtlDO)).where(ExpressionUtils.allOf(predicates))).fetch();
        return ids;
    }

    public List<SaleInvdDtlDTO> getList(Long masId) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (null != masId) {
            predicates.add(this.qSaleInvdDtlDO.masId.eq((Object)masId));
        }
        predicates.add(this.qSaleInvdDtlDO.deleteFlag.eq((Object)0));
        List res = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleInvdDtlDTO.class, (Expression[])new Expression[]{this.qSaleInvdDtlDO.masId, this.qSaleInvdDtlDO.invNo, this.qSaleInvdDtlDO.flowNo, this.qSaleInvdDtlDO.invCode, this.qSaleInvdDtlDO.checkCode, this.qSaleInvdDtlDO.blueInvCode, this.qSaleInvdDtlDO.blueInvNo, this.qSaleInvdDtlDO.redState, this.qSaleInvdDtlDO.redFailCause, this.qSaleInvdDtlDO.invPdfUrl, this.qSaleInvdDtlDO.invFailCause, this.qSaleInvdDtlDO.invDate, this.qSaleInvdDtlDO.totalAmt, this.qSaleInvdDtlDO.invState, this.qSaleInvdDtlDO.id, this.qSaleInvdDtlDO.invoiceRedraftState})).from((EntityPath)this.qSaleInvdDtlDO)).where(ExpressionUtils.allOf(predicates))).fetch();
        return res;
    }

    public PagingVO<SaleInvdDtlVO> getPage(SaleInvdPageParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.qSaleInvdDtlDO.deleteFlag.eq((Object)0));
        if (Strings.isNotBlank((String)param.getRedBlueType())) {
            predicates.add(this.qSaleInvdDtlDO.redBlueType.eq((Object)param.getRedBlueType()));
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleInvdDtlVO.class, (Expression[])new Expression[]{this.qSaleInvdDtlDO.masId, this.qSaleInvdDtlDO.invNo, this.qSaleInvdDtlDO.flowNo, this.qSaleInvdDtlDO.invCode, this.qSaleInvdDtlDO.checkCode, this.qSaleInvdDtlDO.blueInvCode, this.qSaleInvdDtlDO.blueInvNo, this.qSaleInvdDtlDO.redState, this.qSaleInvdDtlDO.redFailCause, this.qSaleInvdDtlDO.invPdfUrl, this.qSaleInvdDtlDO.invFailCause, this.qSaleInvdDtlDO.invDate, this.qSaleInvdDtlDO.totalAmt, this.qSaleInvdDtlDO.invState, this.qSaleInvdDtlDO.id, this.qSaleInvdDtlDO.invoiceRedraftState})).from((EntityPath)this.qSaleInvdDtlDO)).where(ExpressionUtils.allOf(predicates));
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, this.qSaleInvdDtlDO);
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    public void delByMasId(List<Long> masIds) {
        if (CollUtil.isEmpty(masIds)) {
            return;
        }
        this.jpaQueryFactory.delete((EntityPath)this.qSaleInvdDtlDO).where(new Predicate[]{this.qSaleInvdDtlDO.masId.in(masIds)}).execute();
    }

    public void updateRedState(SaleInvdDtlDO saleInvdDtlDO) {
        this.jpaQueryFactory.update((EntityPath)this.qSaleInvdDtlDO).set((Path)this.qSaleInvdDtlDO.redState, (Object)saleInvdDtlDO.getRedState()).where(new Predicate[]{this.qSaleInvdDtlDO.id.eq((Object)saleInvdDtlDO.getId())}).execute();
    }

    public SaleInvDetailAppVO appGet(Long id) {
        return (SaleInvDetailAppVO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleInvDetailAppVO.class, (Expression[])new Expression[]{this.qSaleInvdDtlDO.masId, this.qSaleInvdDtlDO.totalAmt, this.qSaleInvDO.applyNo, this.qSaleInvDO.invType, this.qSaleInvDO.invTitleType, this.qSaleInvDO.invPicName, this.qSaleInvDO.invPicPhone, this.qSaleInvDO.invEmail, this.qSaleInvDO.recApplyTime})).from((EntityPath)this.qSaleInvdDtlDO)).leftJoin((EntityPath)this.qSaleInvDO)).on((Predicate)this.qSaleInvDO.id.eq(this.qSaleInvdDtlDO.masId))).where((Predicate)this.qSaleInvdDtlDO.id.eq((Object)id))).fetchOne();
    }

    public SaleInvdDtlRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

