package com.elitesland.fin.application.service.saleinvd;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDetailAppVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdPageParam;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdParam;
import com.elitesland.fin.domain.service.saleinvd.SaleInvdDomainService;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.saleinv
 * @date 2022/5/6 15:02
 */
@Service
@RequiredArgsConstructor
public class SaleInvdServiceImpl implements SaleInvdService {

    public final SaleInvdDomainService saleInvdDomainService;

    private final SaleInvdDtlRepoProc saleInvdDtlRepoProc;

    public final SaleInvRepo saleInvRepo;

    @Override
    public PagingVO<SaleInvdDtlVO> page(SaleInvdPageParam param) {
        return saleInvdDtlRepoProc.getPage(param);
    }

    @Override
    public void cancel(Long id) {
        saleInvdDomainService.cancel(id);
    }

    @Override
    public void red(Long id) {
        saleInvdDomainService.red(id);
    }

    @Transactional
    @Override
    public InvoiceRedraftPageVO redraft(Long id) {
        return saleInvdDomainService.redraft(id);

    }

    @Override
    public void update(SaleInvdParam param) {
        saleInvdDomainService.update(param);
    }

    @Override
    @SysCodeProc
    public SaleInvDetailAppVO appGet(Long id) {
        return saleInvdDomainService.appGet(id);
    }


}
