package com.elitesland.fin.provider.expense;

import cn.hutool.json.JSONUtil;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.expense.ExpRuleConfigConvert;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigQueryVO;
import com.elitesland.fin.application.service.expense.ExpenseRuleConfigService;
import com.elitesland.fin.param.expense.ExpRuleQueryRpcParam;
import com.elitesland.fin.param.expense.ExpRuleQueryRpcRespVO;
import com.elitesland.fin.service.expense.ExpenseRuleConfigRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/8/16 13:11
 * @Description:
 */
@RequiredArgsConstructor
@Slf4j
@RestController
@RequestMapping(Application.URI_PREFIX + ExpenseRuleConfigRpcService.PATH)
public class ExpenseRuleConfigRpcServiceImpl implements ExpenseRuleConfigRpcService {

    private final ExpenseRuleConfigService expenseRuleConfigService;

    @Override
    public List<ExpRuleQueryRpcRespVO> getList(ExpRuleQueryRpcParam param) {
        ExpRuleConfigQueryParam expRuleConfigQueryParam = new ExpRuleConfigQueryParam();
        expRuleConfigQueryParam.setExpTypeCode(param.getExpTypeCode());
        expRuleConfigQueryParam.setEnableStatus(param.getEnableStatus());
        List<ExpRuleConfigQueryVO> data = expenseRuleConfigService.getListByParam(expRuleConfigQueryParam);

        log.info("计算规则rpc查询结果1:{}", JSONUtil.toJsonStr(data));
        List<ExpRuleQueryRpcRespVO> expRuleQueryRpcRespVOS = ExpRuleConfigConvert.INSTANCE.vo2RpcVoBatch(data);
        log.info("计算规则rpc查询结果2:{}", JSONUtil.toJsonStr(expRuleQueryRpcRespVOS));
        return expRuleQueryRpcRespVOS;
    }
}
