/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class DefaultArExportServiceImpl
implements DataExport<ArExportEntity, ArOrderPageParam> {
    private final ArOrderDomainService arOrderDomainService;
    private final UdcProvider udcProvider;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;

    public String getTmplCode() {
        return "DISABLE";
    }

    @BusinessObjectOperation(permissionRef="fin_ar_order_list", businessObjectType="Fin_Ar_Order:\u5e94\u6536\u5355", operationType=OperationTypeEnum.EXPORT, operationDescription="\u5e94\u6536\u5355\u9ed8\u8ba4\u5bfc\u51fa", operationCode="fin_ar_order_export_default", dataPermissionEnabled=true, fieldPermissionAutoFilter=true)
    public PagingVO<ArExportEntity> executeExport(ArOrderPageParam queryParam) {
        PagingVO<ArExportEntity> arExportEntityPagingVO = this.arOrderDomainService.exportDefault(queryParam);
        if (arExportEntityPagingVO.isEmpty()) {
            return arExportEntityPagingVO;
        }
        Map arDocClsMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "AR_DOC_CLS");
        Map applyStatusMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "APPLY_STATUS");
        Map verifyStatusMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "VERIFY_STATUS");
        Map settlementTypeMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "SETTLEMENT_TYPE");
        Map proposedStatusMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "DOC_PROPOSED_STATUS");
        Map expensesTypeMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "EXPENSES_TYPE");
        ExcelConverterManager.refresh();
        HashMap<Long, BigDecimal> totalCountMap = new HashMap<Long, BigDecimal>();
        for (ArExportEntity record : arExportEntityPagingVO.getRecords()) {
            Long id = record.getId();
            if (totalCountMap.containsKey(id)) {
                record.setTotalCount((BigDecimal)totalCountMap.get(id));
            } else {
                BigDecimal totalCount = this.arOrderDtlRepoProc.countByMasId(id).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                totalCountMap.put(id, totalCount);
                record.setTotalCount(totalCount);
            }
            ExcelConvertUtils.convertSelfLoosely(record);
            record.setOrderStateName((String)applyStatusMap.get(record.getOrderState()));
            record.setExpensesTypeName((String)expensesTypeMap.get(record.getExpensesType()));
            record.setVerStateName((String)verifyStatusMap.get(record.getVerState()));
            record.setSettlementTypeName((String)settlementTypeMap.get(record.getSettlementType()));
            record.setProposedStatusName((String)proposedStatusMap.get(record.getProposedStatus()));
            record.setCreateModeName((String)arDocClsMap.get(record.getCreateMode()));
        }
        return arExportEntityPagingVO;
    }

    public Integer pageSize() {
        return 1000;
    }

    public DefaultArExportServiceImpl(ArOrderDomainService arOrderDomainService, UdcProvider udcProvider, ArOrderDtlRepoProc arOrderDtlRepoProc) {
        this.arOrderDomainService = arOrderDomainService;
        this.udcProvider = udcProvider;
        this.arOrderDtlRepoProc = arOrderDtlRepoProc;
    }
}

