package com.elitesland.fin.application.service.invoice.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.common.PaymentRecordTypeEnum;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.order.param.SalReconciliatInvDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;


@Slf4j
@Service
@RequiredArgsConstructor
public class SalReconciliationInvoiceServiceImpl extends AbstractInvoiceSaveServiceImpl {

    @Autowired
    private RmiOrderRpcService rmiOrderRpcService;

    @Override
    protected PaymentRecordTypeEnum getSourceType() {
        return PaymentRecordTypeEnum.SACCK;
    }

    @Override
    protected void callBackMethod(List<InvoiceAwaitRespVO> records) {
        updateInvingState(records);
    }


    private void updateInvingState(List<InvoiceAwaitRespVO> records) {
        List<SalReconciliatInvDTO> salInvDtoList = new ArrayList<>();
        Set<Long> optDocIds = records.stream().map(InvoiceAwaitRespVO::getOptDocId).filter(Objects::nonNull).collect(Collectors.toSet());
        Optional<String> optional = records.stream().map(InvoiceAwaitRespVO::getInvoiceApplyNo).filter(Objects::nonNull).findFirst();
        String applyNo = optional.get();

        for (Long optDocId : optDocIds) {
            SalReconciliatInvDTO invDTO = new SalReconciliatInvDTO();
            invDTO.setInvState(UdcEnum.INV_STATE_ING.getValueCode());
            invDTO.setId(optDocId);
            invDTO.setInvApplyNo(applyNo);
            salInvDtoList.add(invDTO);
        }

        try {
            Long result = rmiOrderRpcService.updateInvingState(salInvDtoList);
            log.info("回写对账单发票信息: 参数: {},  返回值: {}", salInvDtoList, result);
        } catch (Exception e) {
            log.error("更新对账单发票状态失败: 参数: {} 失败原因: {}", salInvDtoList, e.getMessage());
            throw new BusinessException("更新对账单发票状态失败，" + e.getMessage());
        }
    }

}
