package com.elitesland.fin.application.web.creditaccount;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocParamVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocRespVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocSaveVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountIocService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@RestController
@RequestMapping("/credit/account/ioc")
@RequiredArgsConstructor
@Api(value = "信用账户事务码", tags = {"信用账户事务码"})
public class CreditAccountIocController {

    private final CreditAccountIocService creditAccountIocService;

    /**
     * 新增账户事务码数据
     *
     * @param saveVo 新增账户事务码数据
     * @return 新增账户事务码ID
     */
    @PostMapping("/createOne")
    @ApiOperation("新增账户事务码数据")
    public ApiResult<Long> createOne(@RequestBody CreditAccountIocSaveVO saveVo) {
        return creditAccountIocService.createOne(saveVo);
    }

    /**
     * 修改账户事务码数据
     *
     * @param saveVo 修改账户事务码对象
     * @return 账户事务码ID
     */
    @PutMapping("/update")
    @ApiOperation("修改账户事务码数据")
    public ApiResult<Long> update(@RequestBody CreditAccountIocSaveVO saveVo) {
        return creditAccountIocService.update(saveVo);
    }

    /**
     * 通过账户事务码ID查询单条数据
     *
     * @param id 账户事务码ID
     * @return 单条账户事务码数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过账户事务码ID查询单条数据")
    public ApiResult<CreditAccountIocRespVO> findIdOne(@PathVariable Long id) {
        return creditAccountIocService.findIdOne(id);
    }

    /**
     * 分页查询账户事务码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条账户事务码数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询账户事务码")
    public ApiResult<PagingVO<CreditAccountIocRespVO>> search(@RequestBody CreditAccountIocParamVO param) {
        val ret = creditAccountIocService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 根据入参查询账户事务码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条账户事务码数据
     */
    @PostMapping("/select")
    @ApiOperation("根据入参查询账户事务码")
    public ApiResult<List<CreditAccountIocRespVO>> select(@RequestBody CreditAccountIocParamVO param) {
        val ret = creditAccountIocService.select(param);
        return ApiResult.ok(ret);
    }

    /**
     * 根据账户事务码ID批量逻辑删除
     *
     * @param ids 账户事务码ID集合
     * @return 账户事务码ID集合
     */
    @DeleteMapping("/deleteBatch")
    @ApiOperation("根据账户事务码ID批量逻辑删除")
    public ApiResult<String> deleteBatch(@RequestBody List<Long> ids) {
        return creditAccountIocService.deleteBatch(ids);
    }

}
