package com.elitesland.fin.domain.entity.invoiceredraft;


import com.elitesland.fin.domain.entity.base.BaseWorkflowModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @description
 * @Date 2023/7/14
 */
@Entity
@Table(name = "invoice_redraft")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "invoice_redraft", comment = "重新开票单")
@Data
@Accessors(chain = true)
@ApiModel(value = "invoice_redraft", description = "重新开票单")
public class InvoiceRedraftDO extends BaseWorkflowModel {

    @ApiModelProperty("换开申请单号")
    @Column(name = "orig_apply_no", columnDefinition = "varchar(32) comment '换开申请单号'")
    private String origApplyNo;

    @ApiModelProperty("发票号码")
    @Column(name = "invoice_no", columnDefinition = "varchar(32) comment '发票号码'")
    private String invoiceNo;

    @ApiModelProperty("流水号")
    @Column(name = "serial_no", columnDefinition = "varchar(32) comment '流水号'")
    private String serialNo;

    @ApiModelProperty("开票金额")
    @Column(name = "invoice_amt", columnDefinition = "decimal(18,8) comment '开票金额'")
    private BigDecimal invoiceAmt;

    @ApiModelProperty("开票日期")
    @Column(name = "invoice_date", columnDefinition = "datetime(6) comment '开票日期'")
    private LocalDateTime invoiceDate;

    @ApiModelProperty("发票类型")
    @Column(name = "invoice_type", columnDefinition = "varchar(32) comment '发票类型'")
    private String invoiceType;

    @ApiModelProperty("发票是否抵扣 0-否 1-是")
    @Column(name = "invoice_deduction", columnDefinition = "int(2) comment '发票是否抵扣 0-否 1-是'")
    private Integer invoiceDeduction;

    @ApiModelProperty("换开理由")
    @Column(name = "redraft_reason", columnDefinition = "varchar(128) comment '换开理由'")
    private String redraftReason;

    @ApiModelProperty("附件id")
    @Column(name = "attachment_id", columnDefinition = "varchar(256) comment '附件id'")
    private String attachmentId;

    @ApiModelProperty("单据状态")
    @Column(name = "doc_status", columnDefinition = "varchar(32) comment '单据状态'")
    private String docStatus;

    @ApiModelProperty("新开票申请单号")
    @Column(name = "redraft_apply_no", columnDefinition = "varchar(40) comment '新开票申请单号'")
    private String redraftApplyNo;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '客户编码'")
    private String custCode;

    @Column(name = "store_code", columnDefinition = "varchar(32) comment '门店编码'")
    private String storeCode;

    @Column(name = "sale_inv_title", columnDefinition = "varchar(32) comment '销售方发票抬头'")
    private String saleInvTitle;

    @Column(name = "sale_tax_no", columnDefinition = "varchar(32) comment '销售税号'")
    private String saleTaxNo;

    @Column(name = "sale_tel", columnDefinition = "varchar(32) comment '销售方电话'")
    private String saleTel;

    @Column(name = "sale_add", columnDefinition = "varchar(128) comment '销售详细地址'")
    private String saleAdd;

    @Column(name = "sale_bank", columnDefinition = "varchar(32) comment '销售方开户行'")
    private String saleBank;

    @Column(name = "sale_bank_acc", columnDefinition = "varchar(32) comment '销售方银行账号'")
    private String saleBankAcc;
}
