package com.elitesland.fin.infinity.aisino.vo.param;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedInitialRespVO;
import com.elitesland.fin.infinity.aisino.vo.param.invoice.AisinoRedOpenParam;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.infinity.aisino.utils.InvoiceIssueUtil;
import com.elitesland.fin.infinity.aisino.vo.param.account.BizOrderUploadDatum;
import com.elitesland.fin.infinity.aisino.vo.param.account.BizOrderUploadRequest;
import com.elitesland.fin.infinity.aisino.vo.param.account.Detail;
import lombok.Data;
import org.jetbrains.annotations.NotNull;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Data
public class AisinoApplyPayload {

    /**
     * APPID
     */
    private String APPID;

    /**
     * 请求体
     */
    private String DATA;

    /**
     * 登录账号
     */
    private String USERNAME;


    public static AisinoApplyPayload convert(InvoiceApplySaveParam saveParam) {
        AisinoApplyPayload payload = new AisinoApplyPayload();

        BizOrderUploadDatum row = new BizOrderUploadDatum();
        // 发票请求流水号 = 税号 + 最长30位随机数 唯一值）一个流水号对应一张发票不可重复（防止重复开票），同一流水号最多请求5次(开票失败建议请勿频繁请求）
        row.setFPQQLSH(saveParam.getSaleTaxNo() + saveParam.getApplyNo());

        BizOrderUploadRequest request = new BizOrderUploadRequest();

        // 开票申请单号
        request.setDJH(saveParam.getApplyNo());

        // 开票抬头
        request.setGMFMC(saveParam.getInvCustCode());

        // 纳税人识别号
        request.setGMFSH(saveParam.getCustTaxNo());

        // 开户银行
        request.setGMFYH(saveParam.getInvBankNo());

        // 银行账号
        request.setGMFYHZH(saveParam.getBankAccount());

        // 联查门店开票档案，个人传0，企业传1
        request.setGMFRYXZ("1");

        // 固定传0
        request.setKPLX("0");

        // 对应的中台的发票类型，专票、普票
        if (saveParam.getInvType().equals("VANA")) {
            //电子发票（增值税专用发票）--对应01
            request.setFPZLDM("01");
        } else if (saveParam.getInvType().equals("VANSP")) {
            //电子发票（普通发票）--对应02
            request.setFPZLDM("02");
        }

        // 开票申请金额
        request.setJSHJ(scale(saveParam.getTotalAmt()));

        //个人开票的备注传：
        //购买方地址：；电话：；购方开户银行：；银行账号：；
        //从门店档案的开票字段中获取，多个值用;隔开；
        //企业开票的备注不传；
        if (!Objects.equals(request.getGMFRYXZ(), "1")) {
            request.setBZ("购买方地址：" + saveParam.getCustAdd() + ";电话：" + saveParam.getPhone() + ";购方开户银行：" + saveParam.getCustBank() + ";银行账号：" + saveParam.getCustBankAcc());
        }

        //传销售公司的开户行
        request.setXHFKHH(saveParam.getSaleBank());

        //传销售公司的银行账号
        request.setXHFYHZH(saveParam.getSaleBankAcc());

//        // 业务单类型
//        row.setCustomerBizOrderCategory("加盟商业务单");
//        // 计价方式：0不含税；1含税；
//        row.setPricingMethod("1");
//        // 销方公司编号
//        row.setSellerNo(saveParam.getOuCode());
//        // 销方公司名称
//        row.setSellerName(saveParam.getOuName());
//        // 销方税号
//        row.setSellerTaxNo(saveParam.getSaleTaxNo());
//        // 销方地址
//        row.setSellerAddress(saveParam.getSaleAdd());
//        // 销方电话
//        row.setSellerTel(saveParam.getSaleTel());
//        // 销方银行名称
//        row.setSellerBankName(saveParam.getSaleBank());
//        // 销方银行账号
//        row.setSellerBankAccount(saveParam.getSaleBankAcc());
//        // 购方类型 1-公司 2-个人 可以为空
//        row.setBuyerType("1");
//        // 购方编码
//        row.setBuyerNo(saveParam.getCustCode());
//        // 购方抬头
//        row.setBuyerName(saveParam.getCustInvTitle());
//        // 购方税号
//        row.setBuyerTaxNo(saveParam.getCustTaxNo());
//        // 公司地址
//        row.setBuyerAddress(saveParam.getCustAdd());
//        // 公司电话
//        row.setBuyerTel(saveParam.getCustTel());
//        // 银行名称
//        row.setBuyerBankName(saveParam.getCustBank());
//        // 银行账号
//        row.setBuyerBankAccount(saveParam.getCustBankAcc());
//        // 开票人
//        row.setIssuer(saveParam.getInvUser());
//        // 收款人
//        row.setPayee(saveParam.getRecUser());
//        // 复核人
//        row.setReviewer(saveParam.getRevUser());

        // 不含税金额
        BigDecimal netAmt = BigDecimal.ZERO;
        // 税额
        BigDecimal taxAmt = BigDecimal.ZERO;
        List<Detail> details = new ArrayList<>();
        int lineNo = 1;
        for (InvoiceDetailSaveParam detail : saveParam.getDetails()) {
            netAmt = netAmt.add(detail.getExclTaxAmt());
            taxAmt = taxAmt.add(detail.getTaxAmt());
            Detail drow = new Detail();
            // 序号
            drow.setXH(Integer.toString(lineNo));
            // 明细类别【发票行性质（传空字符串即可，为默认通用单）】
//            drow.setDetailCategory("");
            // 商品编码
            drow.setSPBM(detail.getItemCode());
            // 商品名称
            drow.setSPMC(detail.getItemName());
            // 商品简码 - 税收分类编码
            drow.setSPJM(detail.getTaxCode());
            // 规格型号
            drow.setGGXH(detail.getItemType());
            // 单位
            drow.setJLDW(detail.getUom());
            // 税率，小数，如0.06
            drow.setSLV(detail.getTaxRate().toString());
            // 数量
            drow.setSL(Objects.isNull(detail.getQty()) ? null : detail.getQty().toString());
            // 单价
            drow.setDJ(scale(detail.getPrice()));
            // 含税金额
            drow.setJE(scale(detail.getTotalAmt()));
            // 不含税金额
//            drow.setAmountWithoutTax(scale(detail.getExclTaxAmt()));
            // 税额
            drow.setSE(scale(detail.getTaxAmt()));
            // 抵扣额
            drow.setKCE("0");
            // 0-正常行 1-折扣行 2-被折扣行
            if (detail.getDiscountAmt() != null && detail.getDiscountAmt().compareTo(BigDecimal.ZERO) > 0) {
                drow.setHXZ("2");
            } else {
                drow.setHXZ("0");
            }
            // 含税标志 默认传1（含税）
            drow.setHSBZ("1");
            details.add(drow);

            lineNo++;
            // 是否有着折扣
            if (detail.getDiscountAmt() != null && detail.getDiscountAmt().compareTo(BigDecimal.ZERO) > 0) {
                Detail discountRow = new Detail();

                discountRow.setXH(Integer.toString(lineNo));
                // 商品编码
                discountRow.setSPBM(detail.getItemCode());
                // 商品名称
                discountRow.setSPMC(detail.getItemName());
                // 商品简码 - 税收分类编码
                discountRow.setSPJM(detail.getTaxCode());
                // 规格型号 如果为折扣行，传空
                discountRow.setGGXH("");
                // 单位 如果为折扣行，传空
                discountRow.setJLDW("");
                // 税率，小数，如0.06
                discountRow.setSLV(detail.getTaxRate().toString());

                // 数量 如果为折扣行，传空
                discountRow.setSL("");
                // 单价 如果为折扣行，传空
                discountRow.setDJ("");
                // 含税金额 如果为折扣行，为负数
                discountRow.setJE(scale(detail.getTotalAmt().negate()));
                // 税额 如果为折扣行，为负数
                discountRow.setSE(scale(detail.getTaxAmt().negate()));
                // 抵扣额 如果为折扣行，传空
                discountRow.setKCE("");
                // 商品行没有折扣额则传0
                //有折扣额的如是商品行则传2  折扣行传1
                discountRow.setHXZ("1");
                details.add(discountRow);
                lineNo++;
            }
        }
        // 不含税金额汇总
        request.setHJJE(scale(netAmt));
        // 税额汇总
        request.setHJSE(scale(taxAmt));

        request.setMXLIST(details);

        row.setREQUEST(request);

        // 加密秘钥
        String encryptedData = getEncryptedData(JSONObject.toJSONString(row));
        payload.setDATA(encryptedData);
        return payload;
    }

    public static AisinoApplyPayload convertRedInitial(InvoiceRedApplySaveParam saveParam) {
        AisinoApplyPayload payload = new AisinoApplyPayload();
        AisinoRedPayload row = new AisinoRedPayload();
        // 蓝字发票号码
        row.setLZFPQDHM(saveParam.getOriginApplyNo());

        //  购买方纳税人识别号
        row.setGMFNSRSBH(saveParam.getCustTaxNo());

        // 销售方纳税人识别号
        row.setXSFNSRSBH(saveParam.getSaleTaxNo());

        // 蓝字开票日期 YYYY-MM-DD HH:SS:DD
        row.setLZKPRQ(saveParam.getInvDate().format(java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));

        // 开票方纳税人识别号(销售方纳税人识别号)
        row.setKPFNSRSBH(saveParam.getSaleTaxNo());

        // 归集标签
        row.setGJBQ("1");
        // 特定要素类型代码
        row.setTDYSLXDM("");
        // 对应的中台的发票类型，专票、普票
        // 01-增值税专用发票  对应81
        // 02-增值税普通发票  对应82
        if (saveParam.getInvType().equals("VANA")) {
            //电子发票（增值税专用发票）--对应01
            row.setFPLXDM("81");
        } else if (saveParam.getInvType().equals("VANSP")) {
            //电子发票（普通发票）--对应02
            row.setFPLXDM("82");
        }

        // 蓝字发票号码（纸质）不传
        row.setLZFPHM("");
        // 蓝字发票代码（纸质） 不传
        row.setLZFPDM("");
        //发票来源代码 固定传2
        row.setFPLYDM("2");
        String encryptedData = getEncryptedData(JSONObject.toJSONString(row));
        payload.setDATA(encryptedData);
        return payload;
    }


    public static AisinoApplyPayload convertRedSave(InvoiceRedInitialRespVO saveParam) {
        return getAisinoApplyPayload(JSONObject.toJSONString(saveParam));
    }


    public static AisinoApplyPayload convertRedOpen(AisinoRedOpenParam saveParam) {
        return getAisinoApplyPayload(JSONObject.toJSONString(saveParam));
    }

    @NotNull
    private static AisinoApplyPayload getAisinoApplyPayload(String saveParam) {
        AisinoApplyPayload payload = new AisinoApplyPayload();
        String encryptedData = getEncryptedData(saveParam);
        payload.setDATA(encryptedData);
        return payload;
    }

    @NotNull
    private static String getEncryptedData(String row) {
        // 加密秘钥
        String key = "12345678";
        // 加密 数据
        byte[] encryptedBytes = InvoiceIssueUtil.encrypt(row.getBytes(), key);
        if (encryptedBytes == null) {
            throw new RuntimeException("加密失败,加密结果为空，加密数据:" + row);
        }
        return InvoiceIssueUtil.byteToHexString(encryptedBytes);
    }

    private static String scale(BigDecimal num) {
        return num.setScale(2, RoundingMode.HALF_UP).toString();
    }
}
