package com.elitesland.fin.application.convert.flow;


import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.excel.entity.AccountFlowExportEntity;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import com.elitesland.fin.param.generateaccountflow.GenerateAccountFlowRpcParam;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface AccountFlowConvert {
    AccountFlowConvert INSTANCE = Mappers.getMapper(AccountFlowConvert.class);

    /**
     * VO类型转换DO
     * @param accountFlowVO
     * @return DO
     */
    AccountFlowDO voToDo(AccountFlowVO accountFlowVO);

    /**
     * Param类型转换DO
     * @param accountFlowParam
     * @return DO
     */
    AccountFlowDO paramToDo(AccountFlowParam accountFlowParam);

    /**
     * RpcParam类型转换Param
     * @param accountFlowRpcParam
     * @return Param
     */
    AccountFlowParam rpcParamToParam(AccountFlowRpcParam accountFlowRpcParam);

    List<AccountFlowExportEntity> accountFlowVOs2AccountFlowExportEntitys(List<AccountFlowVO> accountFlowVOs);

    AccountFlowParam accountFlowRpcParam2AccountFlowParam(AccountFlowRpcParam accountFlowRpcParam);

    AccountFlowParam copyParam(AccountFlowParam accountFlowParam);

    List<AccountFlowParam> rpcParam2Param(List<GenerateAccountFlowRpcParam> param);
}
