package com.elitesland.fin.application.facade.dto.writeoff;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 单据审批请求参数.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
public class FinArRecApplyApprovalDTO implements Serializable {

    private static final long serialVersionUID = -8312869386278889077L;

    @ApiModelProperty("申请单号")
    @NotEmpty(message = "申请单号不能为空")
    private List<String> applyNos;

    @ApiModelProperty("审批类型 APPROVE:通过 REFUSE:拒绝")
    private ApprovalType approvalType;

    @ApiModelProperty("审批意见")
    private String approvalRemark;

    public enum ApprovalType {
        // 通过
        APPROVE,
        // 拒绝
        REFUSE,
    }
}
