package com.elitesland.fin.application.facade.param.invoiceredraft;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @description
 * @Date 2023/7/14
 */
@Data
@ApiModel("重新开票保存或更新")
public class InvoiceRedraftSaveParam extends CustomFieldBaseModelVo {

    @ApiModelProperty("换开申请单号")
    private String origApplyNo;

    @ApiModelProperty("发票号码")
    private String invoiceNo;

    @ApiModelProperty("流水号")
    private String serialNo;

    @ApiModelProperty("开票金额")
    private BigDecimal invoiceAmt;

    @ApiModelProperty("开票日期")
    private LocalDateTime invoiceDate;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("发票是否抵扣 0-否 1-是")
    private Integer invoiceDeduction;

    @ApiModelProperty("换开理由")
    private String redraftReason;

    @ApiModelProperty("附件id")
    private String attachmentId;

    @ApiModelProperty("审批状态 [UDC]yst-franchisee:FLOW_STATUS")
    private ProcInstStatus workflowProcInstStatus;

}
