package com.elitesland.fin.application.service.invoice;

import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.param.saleinv.ApplyInvoiceRpcParam;
import com.elitesland.fin.param.saleinv.InvoiceQueryParam;
import com.elitesland.fin.param.saleinv.InvoiceSaveParam;
import com.elitesland.fin.param.saleinv.XforceResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


public interface InvoiceApplyService {

    /**
     * 根据业务单据 - 提交开票申请
     *
     * @param param 开票参数
     * @return 开票申请单
     */
    @PostMapping("/apply/create")
    List<InvoiceApplyRpcDTO> create(@RequestBody List<InvoiceApplySaveParam> param);

    /**
     * 根据业务单据 - 保存发票信息
     *
     * @param param 发票参数
     */
    @PostMapping("/apply/invoice/save")
    void saveInvoice(@RequestBody List<InvoiceSaveParam> param);

    /**
     * 根据单据编码 - 获取单据ID
     *
     * @param applyNo 单据编码
     * @return 单据ID
     */
    @GetMapping("/apply/getId")
    InvoiceApplyRpcDTO queryIdByApplyNo(@RequestParam("applyNo") String applyNo);

    /**
     * 根据来源单据ID - 获取申请单据ID
     *
     * @param param 查询条件
     * @return 单据列表
     */
    @PostMapping("/apply/query")
    List<InvoiceApplyRpcDTO> queryIdBySource(@RequestBody InvoiceQueryParam param);

    /**
     * 更新票易通上传结果
     *
     * @param xforceResult 结果状态
     */
    @PostMapping("/apply/xforce/upload")
    void updateXforceResult(@RequestBody XforceResult xforceResult);

    /**
     * 根据加盟商code查询发票抬头
     *
     * @return
     */
//    @PostMapping("/apply/xforce/invQuery")
//    List<InvoiceRpcDTO> invQueryRpc(@RequestBody List<ApplyInvoiceRpcParam> applyInvoiceParam);
}
