package com.elitesland.fin.domain.service.report;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.report.IpvRespVO;
import com.elitesland.fin.application.facade.vo.report.IpvSumRespVO;
import com.elitesland.fin.domain.param.report.IpvInvoicePageParam;
import com.elitesland.fin.infr.repo.report.IpvInvoiceRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@RequiredArgsConstructor
public class IpvCommonDomainServiceImpl implements IpvCommonDomainService {

    private final IpvInvoiceRepoProc ipvInvoiceRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<IpvRespVO> page(IpvInvoicePageParam paramVO) {
        long count = ipvInvoiceRepoProc.countIpvInvoice(paramVO);
        if (count > 0) {
            var invoice = ipvInvoiceRepoProc.queryIpvInvoice(paramVO);
            return new PagingVO<>(count, invoice);
        }
        return new PagingVO<>();
    }

    @Override
    public IpvSumRespVO sumIpv(IpvInvoicePageParam paramVO) {
        return ipvInvoiceRepoProc.sumIpvInvoice(paramVO);
    }
}
