package com.elitesland.fin.application.web.creditaccount;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountRuleConfigSaveParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigQueryVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountRuleConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */

@RestController
@RequestMapping("/credit/account/rule/config")
@Api(value = "信用账户规则配置", tags = {"信用账户规则配置"})
@AllArgsConstructor
public class CreditAccountRuleConfigController {

    private final CreditAccountRuleConfigService creditAccountRuleConfigService;

    @PostMapping("/page")
    @ApiOperation("账户规则配置-分页查询")
    public ApiResult<PagingVO<CreditAccountRuleConfigPageVO>> page(@RequestBody CreditAccountRuleConfigQueryParam param) {
        val ret = creditAccountRuleConfigService.searchPage(param);
        return ApiResult.ok(ret);
    }
    @PostMapping("/detail/{masId}")
    @ApiOperation("账户规则配置-详情")
    public ApiResult<CreditAccountRuleConfigQueryVO> detail(@PathVariable("masId") Long masId) {
        val ret = creditAccountRuleConfigService.detail(masId);
        return ApiResult.ok(ret);
    }
    @PostMapping("/save")
    @ApiOperation("账户规则配置-保存/更新")
    public ApiResult<Void> save(@RequestBody CreditAccountRuleConfigSaveParam param) {
        creditAccountRuleConfigService.saveOrUpdate(param);
        return ApiResult.ok();
    }
    @GetMapping("/del/{masId}")
    @ApiOperation("账户规则配置-删除")
    public ApiResult<Void> del(@PathVariable("masId") Long masId) {
        creditAccountRuleConfigService.del(masId);
        return ApiResult.ok();
    }
}