package com.elitesland.fin.application.facade.param.account;

import com.elitescloud.boot.core.support.customfield.common.AbstractCustomFieldQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/08/09
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "accountAppParam",description = "账户和信用账户查询入参")
public class AccountAppParam extends AbstractCustomFieldQueryParam {
    private static final long serialVersionUID = -3560912759720677589L;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty(value = "公司编号")
    private String ouCode;

    @ApiModelProperty("账户类型(储值、返利、信用账户)")
    private String accountType;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("交易日期起始")
    private LocalDateTime transactionTimeS;

    @ApiModelProperty("交易日期截至")
    private LocalDateTime transactionTimeE;

    @ApiModelProperty("发生金额从")
    private BigDecimal amountFrom;

    @ApiModelProperty("发生金额至")
    private BigDecimal amountTo;

    @ApiModelProperty("交易类型集合")
    private List<String> transactionTypeList;

    @ApiModelProperty("来源单据集合")
    private List<String> sourceDocList;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("交易日期近几个月(数字为几则往前推几个月)")
    private Integer previousMonth;

    @ApiModelProperty("审核时间起始")
    private LocalDateTime auditDateS;

    @ApiModelProperty("审核时间截至")
    private LocalDateTime auditDateE;

    @ApiModelProperty("来源根单号")
    private String rootDocNo;

}
