package com.elitesland.fin.application.service.unionpay.entity.req;

import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author sunxw
 * @description 支付请求参数
 * @Date 2023/6/2
 */
@Data
public class SendPayReq {

    @ApiModelProperty("收款方式")
    //@SysCode(sys = "yst-fin",mod = "PAY_METHOD")
    private String recType;

    @ApiModelProperty("储值订单id/主键")
    private Long storageId;

    @ApiModelProperty("支付流水号")
    private String payOrderId;

    @ApiModelProperty("单据状态")
    private String receiptStatus;

    @ApiModelProperty("汇款金额")
    private BigDecimal remitterAmt;

    @ApiModelProperty("汇款银行code")
    private String remitterBankCode;

    @ApiModelProperty("支付异步前端回调地址，可不传")
    private String merPageUrl;

    @ApiModelProperty("汇款账号")
    private String remitterAccount;

    @ApiModelProperty("汇款银行名称")
    private String remitterBankName;

    @ApiModelProperty("收款人")
    private String recUser;

    @ApiModelProperty("收款银行")
    private String recBank;

    @ApiModelProperty("收款账号")
    private String recAcc;

    @ApiModelProperty("支付凭证")
    private String applyFile;

    @ApiModelProperty("工作流-流程实例状态")
    private ProcInstStatus workflowProcInstStatus;

    @ApiModelProperty("工作流-流程实例ID")
    private String workflowProcInstId;

    @ApiModelProperty(value = "工作流-提交时间")
    private LocalDateTime workflowSubmitTime;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "工作流-当前审批节点KEY")
    private String workflowCurrentNodeKey;

    @ApiModelProperty(value = "工作流-当前审批节点名称")
    private String workflowCurrentNodeName;

    @ApiModelProperty(value = "工作流-当前节点审批人用户ID（多个使用逗号分隔）")
    private String workflowCurrentUserIds;

    @ApiModelProperty(value = "工作流-审批驳回原因")
    private String workflowRejectedMessage;

    @ApiModelProperty(value = "工作流-审批通过时间")
    private LocalDateTime workflowEndTime;
}
