package com.elitesland.fin.domain.service.recorder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.excel.entity.RecOrderEntity;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderParam;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.workflow.ProcessInfo;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/13 10:32
 */
public interface RecOrderDomainService {

    PagingVO<RecOrderDTO> page(RecOrderPageParam param);
    public PagingVO<RecOrderDTO> writeoffPage(RecOrderPageParam param);

    /**
     * 根据主键ID查询详细信息
     * @param  flag true 表示查询明细，false不查询明细
     * @param id 主键ID
     * @return 详细信息
     */
    RecOrderDTO queryById(Long id, Boolean flag);

    List<RecOrderDTO> queryByIds(List<Long> ids, Boolean flag);

    /**
     * 根据ID删除付款单
     *
     * @param ids
     * @return
     */
    List<Long> deleteByIds(List<Long> ids);

    /**
     * 保存收款单数据
     *
     * @param recOrder 实体收款单
     * @return 更新ID
     */
    Long save(RecOrder recOrder);

    /**
     * 提交收款单数据
     * @param auto 是否自动审核
     * @param payOrder 实体收款单
     * @return 更新ID
     */
    Long submit(RecOrder payOrder,Boolean auto);

    /**
     * 根据收款单类型查询数据
     * @param recTypeId
     * @return
     */
    List<RecOrderDTO> queryByRecTypeId(List<Long> recTypeId);

    /**
     * 根据参数查询付款单数据
     * @param recOrderParam 查询参数
     * @return 付款单信息
     */
    List<RecOrderDTO> queryByParam(RecOrderParam recOrderParam);

    /**
     * 更新核销金额
     * @param id
     * @param amt
     */
    void updateVerAmt(Long id, BigDecimal amt);

    void updateWorkInfo(ProcessInfo processInfo, Long id);

    /**
     * 红冲单据创建
     * @param id
     * @return
     */
    RecOrder redPunchCreate(Long id);

    /**
     * 生成财务流水
     *
     * @param recOrderDTO
     */
    void createFinFlow(RecOrderDTO recOrderDTO);

    /**
     * 导出收款单
     * @param param
     * @return
     */
    PagingVO<RecOrderEntity> exportRecOrder(RecOrderPageParam param);
}
