package com.elitesland.fin.infr.dto.aporder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.dto.aporder
 * @date 2022/3/16 11:06
 */
@Data
public class ApOrderDTO implements Serializable {


    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-purc", mod = "IO_TYPE")
    private String inOutCust;
    private String inOutCustName;

    private static final long serialVersionUID = 5101455037990752648L;
    private Long id;

    private String sourceNo;

    private String apOrderNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private String createMode;

    private Long apTypeId;

    private String apTypeName;

    private String apTypeCode;

    private String orderState;

    private LocalDateTime buDate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String currCode;

    private String currName;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private BigDecimal exchangeRate;

    private Long operUserId;

    private String operator;

    private Boolean taxFlag;

    private Boolean initFlag;

    private String auditRejection;

    private Long suppId;

    private String suppCode;

    private String suppName;

    private Long buId;

    private String buCode;

    private String buName;

    private String buType;

    private String payMentName;

    private String payMentId;

    private String payMentCode;

    private LocalDateTime createTime;

    private String updater;

    private LocalDateTime modifyTime;

    private String creator;

    private String remark;

    private BigDecimal totalCount;

    private String localCurrCode;

    private String localCurrName;

    private BigDecimal taxRate;

    private List<ApOrderDtlDTO> apOrderDtlDTOList;

    private List<ApOrderDtlGroupDTO> apOrderDtlGroupDTOList;

    private String verState;

    private BigDecimal verAmt;
    
    private BigDecimal unVerAmt;

    private Integer auditDataVersion;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private String addrNo;

    private String suppAddrNo;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    private String proposedStatus;

    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;

    @ApiModelProperty("应付暂估差异")
    private BigDecimal invoicePriceVariance;

    @ApiModelProperty("付款协议编码")
    private String protocolCode;
    @ApiModelProperty("协议名称")
    private String protocolName;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
    @ApiModelProperty("关联公司名称")
    private String relevanceOuName;
}
