package com.elitesland.fin.application.facade.vo.account;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowAppVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author chaofeng.xia
 * @since 2025/8/19
 */
@Data
@ApiModel(value = "accountTypeFlowVO",description = "按照类型查询账户、信用账户和流水信息出参")
public class AccountGroupFlowVO implements Serializable {
    private static final long serialVersionUID = 6951953004687690898L;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin", mod = "ACCOUNT_TYPE")
    private String accountType;
    @ApiModelProperty("账户类型名称")
    private String accountTypeName;

    @ApiModelProperty("余额")
    private BigDecimal accountAmount;

    @ApiModelProperty("占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("账户或信用账户和流水")
    private List<AccountFlowAppVO> flowList;


}
