package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyArHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyArHeadSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApHeadVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyArHeadVO;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyArHeadDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyArHeadRepo;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyArHeadRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinArRecVerApplyArHeadServiceImpl implements FinArRecVerApplyArHeadService {

    private final FinArRecVerApplyArHeadRepo finArRecVerApplyArHeadRepo;

    private final FinArRecVerApplyArHeadRepoProc finArRecVerApplyArHeadRepoProc;
    private final FlexFieldUtilService flexFieldUtilService;
    private final ArOrderRepoProc arOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    public Long create(Long masId, FinArRecVerApplyArHeadSaveDTO param) {
        Assert.notNull(masId, "主表ID不能为Null");
        FinArRecVerApplyArHeadDO entity = FinArRecVerApplyArHeadConvert.INSTANCE.DTO2DO(param);
        entity.setMasId(masId);

        if (StringUtils.isBlank(entity.getInOutCust()) || StringUtils.isBlank(entity.getRelevanceOuCode())){
            List<ArOrderDTO> arOrderDTOList = arOrderRepoProc.selectInOutCustByArOrderNo(Collections.singletonList(entity.getArOrderNo()));
            Map<String, ArOrderDTO> arOrderMap = CollectionUtil.isEmpty(arOrderDTOList) ? new HashMap<>() : arOrderDTOList.stream().collect(Collectors.toMap(ArOrderDTO::getArOrderNo, t -> t, (t1, t2) -> t1));
            ArOrderDTO arOrderDTO = arOrderMap.get(entity.getArOrderNo());
            if (Objects.nonNull(arOrderDTO)){
                String inOutCust = StringUtils.isBlank(entity.getInOutCust()) ? arOrderDTO.getInOutCust() : entity.getInOutCust();
                String relevanceOuCode = StringUtils.isBlank(entity.getRelevanceOuCode()) ? arOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                entity.setInOutCust(inOutCust);
                entity.setRelevanceOuCode(relevanceOuCode);
            }
        }


        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.FIN_AR_REC_VER_APPLY_AR_HEAD, entity);
        return finArRecVerApplyArHeadRepo.save(entity).getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finArRecVerApplyArHeadRepoProc.deleteByMasId(masIds);
    }

    @Override
    @SysCodeProc
    public List<FinArRecVerApplyArHeadVO> listByMasIds(Collection<Long> masIds) {
        List<FinArRecVerApplyArHeadVO> finArRecVerApplyArHeadVOList = finArRecVerApplyArHeadRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinArRecVerApplyArHeadConvert.INSTANCE::DO2VO)
                .collect(Collectors.toList());

        if (CollectionUtil.isEmpty(finArRecVerApplyArHeadVOList)){
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finArRecVerApplyArHeadVOList.stream().map(FinArRecVerApplyArHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finArRecVerApplyArHeadVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)){
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });

        return finArRecVerApplyArHeadVOList;
    }

	@Override
	@SysCodeProc
	public List<FinArRecVerApplyArHeadVO> listByIds(Collection<Long> ids, FinArRecVerApplyQuery query) {
		return finArRecVerApplyArHeadRepoProc.listByIds(ids,query)
				.stream()
				.map(FinArRecVerApplyArHeadConvert.INSTANCE::DO2VO)
				.collect(Collectors.toList());
	}
}
