package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_fast_code")
@org.hibernate.annotations.Table(appliesTo = "fin_fast_code", comment = "快码")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinFastCodeDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "fast_code", columnDefinition = "varchar(20) comment '快码编码'")
    private String fastCode;

    @Column(name = "fast_name", columnDefinition = "varchar(32) comment '快码名称'")
    private String fastName;

    @Column(name = "status", columnDefinition = "varchar(32) comment '状态'")
    private String status;
}
