package com.elitesland.fin.entity.push;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/26 周六
 */
@Entity
@Table(name = "fin_push_result", indexes = {
        @Index(name = "idx_fin_push_result_docno", columnList = "docNo"),
        @Index(name = "idx_fin_push_result_docid", columnList = "docId"),
        @Index(name = "idx_fin_push_result_intercode", columnList = "interCode"),
        @Index(name = "idx_fin_push_result_pushtime", columnList = "pushTimeLast"),
})
@Comment("推送结果")
@Getter
@Setter
public class FinPushResultDO extends BaseModel {
    private static final long serialVersionUID = 5201681032669595541L;

    /**
     * @see com.elitesland.fin.common.FinPushTarget
     */
    @Column()
    @Comment(value = "目标类型")
    private String targetType;

    /**
     * @see com.elitesland.fin.common.FinPushDocType
     */
    @Column()
    @Comment(value = "单据类型")
    private String docType;

    @Column()
    @Comment(value = "单据编号")
    private String docNo;

    @Column()
    @Comment(value = "单据ID")
    private Long docId;

    /**
     * @see com.elitesland.fin.common.FinPushInter
     */
    @Column()
    @Comment(value = "接口编码")
    private String interCode;

    @Column()
    @Comment(value = "推送结果[UDC]yst-supp:PUSH_RESULT")
    private String pushResult;

    @Column()
    @Comment(value = "首次推送时间")
    private LocalDateTime pushTimeFirst;

    @Column()
    @Comment(value = "最后推送时间")
    private LocalDateTime pushTimeLast;

    @Column()
    @Comment(value = "推送失败原因")
    private String failReason;

    @Column()
    @Comment(value = "推送记录ID")
    private Long pushRecordId;
}
