package com.elitesland.fin.config;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.facade.dto.mq.AdjustOrderSubmitProcessMqMessageDTO;
import com.elitesland.fin.application.facade.dto.mq.InvoiceOpeningProcessMqMessageDTO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.service.invoice.impl.AbstractInvoiceSaveServiceImpl;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.utils.BeanUtils;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 *
 * Created by lance on 2025/10/31.
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class InvoiceJobHandler {

    private final SaleInvdDtlRepo saleInvdDtlRepo;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final MessageQueueTemplate messageQueueTemplate;
    private final AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;
    /**
     * 定时获取开票结果
     *
     * @param param
     * @return
     */
    @XxlJob(JobConstant.INVOICE_ORDER_GET_RESULT)
    public ReturnT<String> invoiceGetResult(String param) {
        try {
            log.info("开始扫描开票中的发票...");
            List<SaleInvdDtlDO> allByInvState = saleInvdDtlRepo.findAllByInvState(UdcEnum.INV_STATE_ING.getValueCode());
            if (allByInvState != null && !allByInvState.isEmpty()) {
                log.info("找到 {} 条开票中的发票，开始提交...", allByInvState.size());
                // 提交每个开票中的发票，发送MQ
                for (SaleInvdDtlDO draftOrder : allByInvState) {
                    AdjustOrderSubmitProcessMqMessageDTO messageDTO = new AdjustOrderSubmitProcessMqMessageDTO();
                    messageDTO.setId(draftOrder.getId());
                    messageDTO.setBusinessKey(draftOrder.getFlowNo());
                    try {
                        messageQueueTemplate.publishMessage(Application.NAME, InvoiceOpeningProcessMqMessageDTO.SUBMIT_CHANNEL, messageDTO);
                    } catch (Exception e) {
                        log.error("发送mq消息，处理开票中的发票,同步内容{}, 失败原因：{}", messageDTO, e.getMessage());
                    }
                }
            } else {
                log.info("未找到开票中的发票");
            }
        } catch (Exception e) {
            log.error("定时提交开票中的发票时发生异常", e);
        }
        return ReturnT.SUCCESS;
    }


    // 定时提交开票
    @XxlJob(JobConstant.INVOICE_ORDER_SUBMIT)
    public ReturnT<String> invoiceSubmit(String param) {
        try {
            log.info("开始扫描待开发票申请...");
            List<SaleInvDO> allByInvState = saleInvRepo.findAllByInvState(UdcEnum.INV_STATE_WAIT.getValueCode());
            if (CollectionUtil.isEmpty(allByInvState)) {
                log.info("未找到待开发票申请");
                return ReturnT.SUCCESS;
            }

            List<Long> masIdList = allByInvState.stream().map(BaseModel::getId).toList();
            List<SaleInvDtlDO> allByMasIdIn = saleInvDtlRepo.findAllByMasIdIn(masIdList);
            Map<Long, List<SaleInvDtlDO>> saleInvDtlMap = allByMasIdIn.stream().collect(Collectors.groupingBy(SaleInvDtlDO::getMasId));

            List<InvoiceApplySaveParam> invoiceApplySaveParamList = new ArrayList<>();
            for (SaleInvDO record : allByInvState) {
                List<SaleInvDtlDO> saleInvDtlDOS = saleInvDtlMap.get(record.getId());

                InvoiceApplySaveParam saveParam = new InvoiceApplySaveParam();
                BeanUtils.copyProperties(record, saveParam);

                // 设置发票详情
                if (saleInvDtlDOS != null && !saleInvDtlDOS.isEmpty()) {
                    List<InvoiceDetailSaveParam> detailList = saleInvDtlDOS.stream().map(detail -> {
                        InvoiceDetailSaveParam invoiceDetail = new InvoiceDetailSaveParam();
                        BeanUtils.copyProperties(detail, invoiceDetail);
                        return invoiceDetail;
                    }).toList();
                    saveParam.setDetails(detailList);
                }
                invoiceApplySaveParamList.add(saveParam);
            }

            if (CollectionUtil.isNotEmpty(invoiceApplySaveParamList)) {
                log.info("找到 {} 条待开申请发票，开始提交...", invoiceApplySaveParamList.size());
                // 提交每个待开申请发票，发送MQ
                Map<String, InvoiceApplySaveParam> saveParamMap = invoiceApplySaveParamList.stream().collect(Collectors.toMap(InvoiceApplySaveParam::getApplyNo, Function.identity()));
                saveParamMap.forEach((key, value) -> {
                    if (value.getTotalAmt().compareTo(BigDecimal.ZERO) < 0) {
                        // todo 开红票 如何找蓝票
                    } else {
                        abstractInvoiceSaveService.invoiceApply(value, null);
                    }
                });
            }
        } catch (Exception e) {
            log.error("定时提交开票中的发票时发生异常", e);
        }
        return ReturnT.SUCCESS;
    }

}
