package com.elitesland.fin.domain.entity.writeoff;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 应收收款核销申请单明细-应收单.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Entity
@Table(name = "fin_ar_rec_ver_apply_ar",
        indexes = {
                @Index(name = "idx_masId", columnList = "masId")
        })
@DynamicInsert
@DynamicUpdate
@Comment("应收收款核销申请单明细-应收单")
@Getter
@Setter
@Accessors(chain = true)
public class FinArRecVerApplyArDO extends BaseModel {

    private static final long serialVersionUID = -1241790256610034591L;

    @Comment("主表ID")
    @Column(nullable = false)
    private Long masId;

    @Comment("应收单ID")
    @Column(nullable = false)
    private Long arId;

    @Comment("应收单号")
    @Column(nullable = false, length = 64)
    private String arDocNo;

    @Comment("应收单明细ID")
    @Column(name = "ar_d_id")
    private Long arDId;

    @Comment("第三方应收单ID")
    @Column(nullable = false)
    private Long outArId;

    @Comment("第三方应收单号")
    @Column(nullable = false, length = 64)
    private String outArDocNo;

    @Comment("订单号")
    @Column(length = 32)
    private String orderNo;

    @Comment("发货单号")
    @Column(length = 32)
    private String sendOrder;

    @Comment("第三方应收单明细ID")
    @Column(name = "out_ar_d_id", length = 32)
    private String outArDId;

    @Comment("应收单类型ID")
    @Column()
    private Long arTypeId;

    @Comment("应收单类型编码")
    @Column(length = 32)
    private String arTypeCode;

    @Comment("应收单类型名称")
    @Column(length = 32)
    private String arTypeName;

    @Comment("公司ID")
    @Column()
    private Long ouId;

    @Comment("公司编码")
    @Column(length = 32)
    private String ouCode;

    @Comment("公司名称")
    @Column(length = 32)
    private String ouName;

    @Comment("部门ID")
    @Column()
    private Long buId;

    @Comment("部门编码")
    @Column(length = 32)
    private String buCode;

    @Comment("部门名称")
    @Column(length = 32)
    private String buName;

    @Comment("业务员ID")
    @Column(length = 32)
    private Long salesmanId;

    @Comment("业务员编码")
    @Column(length = 32)
    private String salesmanCode;

    @Comment("业务员名称")
    @Column(length = 32)
    private String salesmanName;

    @Comment("发票号")
    @Column(length = 32)
    private String invoiceNumber;

    @Comment("开票日期")
    @Column()
    private LocalDateTime invDate;

    @Comment("发票类型")
    @Column(length = 16)
    private String invType;

    @Comment("来源单号")
    @Column(length = 64)
    private String sourceNo;

    @Comment("订货日期")
    @Column(length = 64)
    private String ordererDate;

    @Comment("订货人")
    @Column(length = 16)
    private String ordererName;

    @Comment("订货人电话")
    @Column(length = 16)
    private String ordererPhone;

    @Comment("订货人地址")
    @Column(length = 64)
    private String ordererAddr;

    @Comment("渠道类型")
    @Column(length = 32)
    private String chanType;

    @Comment("打款方式")
    @Column(length = 32)
    private String payoutsType;

    @Comment("客户ID")
    @Column(length = 32)
    private Long custId;

    @Comment("客户编码")
    @Column(length = 32)
    private String custCode;

    @Comment("客户名称")
    @Column(length = 32)
    private String custName;

    @Comment("子客户ID")
    @Column(length = 32)
    private Long subCustId;

    @Comment("子客户编码")
    @Column(length = 32)
    private String subCustCode;

    @Comment("子客户名称")
    @Column(length = 32)
    private String subCustName;

    @Comment("商品ID")
    @Column()
    private Long itemId;

    @Comment("商品编码")
    @Column(length = 32)
    private String itemCode;

    @Comment("商品名称")
    @Column(length = 32)
    private String itemName;

    @Comment("规格型号")
    @Column(length = 32)
    private String itemType;

    @Comment("数量")
    @Column(precision = 16, scale = 4)
    private BigDecimal qty;

    @Comment("含税单价")
    @Column(precision = 20, scale = 4)
    private BigDecimal price;

    @Comment("含税总金额")
    @Column(precision = 20, scale = 4)
    private BigDecimal totalAmt;

    @Comment("应收单单据日期")
    @Column()
    private LocalDateTime arDate;

    @Comment("备注")
    @Column()
    private String remark;

    @Comment("未核销金额")
    @Column(precision = 20, scale = 4)
    private BigDecimal notVerAmt;

    @Comment("本次核销金额")
    @Column(precision = 20, scale = 4)
    private BigDecimal verAmt;

    @Column(name = "in_out_cust", columnDefinition = "varchar(40)  comment '内外部客户'")
    private String inOutCust;

    @Column(name = "relevance_ou_code", columnDefinition = "varchar(32) comment '关联公司编码'")
    private String relevanceOuCode;

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof FinArRecVerApplyArDO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
