package com.elitesland.fin.infr.dto.paymentperiod;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/17
 * @Version 1.0
 * @Content:
 */
@Data
public class AgingRangeOuDTO extends BaseModelDTO implements Serializable {
    private static final long serialVersionUID = -6658408762538003171L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司类型")
    @SysCode(sys = "yst-supp", mod = "OU_TYPE")
    private String ouType;
    private String ouTypeName;
}
