package com.elitesland.fin.domain.service.arorder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.arorder
 * @date 2022/4/13 15:00
 */
@Service
@RequiredArgsConstructor
public class ArOrderDtlDomainServiceImpl implements ArOrderDtlDomainService {

    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;

    @Override
    public PagingVO<ArOrderDtlDTO> page(ArOrderDtlPageParam arOrderDtlPageParam) {
        PagingVO<ArOrderDtlDTO> pagingVO = arOrderDtlRepoProc.page(arOrderDtlPageParam);
        List<ArOrderDtlDTO> arOrderDtlDTOList = pagingVO.getRecords();
        if (CollectionUtil.isEmpty(arOrderDtlDTOList)){
            return PagingVO.<ArOrderDtlDTO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        List<String> dtlProtocolCodeList = arOrderDtlDTOList.stream().map(ArOrderDtlDTO::getProtocolCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, ReceiptPaymentAgreementVO> agreementMap = receiptPaymentAgreementDomainService.selectReceiptAgreementByCodes(dtlProtocolCodeList);
        handleApOrderDtlDTO(arOrderDtlDTOList,agreementMap);

        return PagingVO.<ArOrderDtlDTO>builder()
                .total(pagingVO.getTotal())
                .records(arOrderDtlDTOList)
                .build();
    }

    private void handleApOrderDtlDTO(List<ArOrderDtlDTO> arOrderDtlDTOS,Map<String, ReceiptPaymentAgreementVO> agreementMap){
        if (CollectionUtil.isNotEmpty(arOrderDtlDTOS)){
            arOrderDtlDTOS.forEach(arOrderDtlDTO -> {
                if (MapUtil.isNotEmpty(agreementMap) && agreementMap.containsKey(arOrderDtlDTO.getProtocolCode())){
                    ReceiptPaymentAgreementVO agreementVO = agreementMap.get(arOrderDtlDTO.getProtocolCode());
                    if (Objects.nonNull(agreementVO)){
                        arOrderDtlDTO.setProtocolName(agreementVO.getProtocolName());
                    }
                }
            });
        }

    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long del(List<Long> ids) {
        Long res = arOrderDtlRepoProc.del(ids);
        return res;
    }
}
