package com.elitesland.fin.entity.cgorder;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : http://www.chiner.pro
 * @date : 2023-2-20
 * @desc : 充值单
 */
@Entity
@org.hibernate.annotations.Table(appliesTo = "cg_order", comment = "充值单")
@Table(name="cg_order")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0")
public class CgOrderDO extends BaseModel{

    @Column(name = "doc_no", columnDefinition = "varchar(32) comment '单号'")
    private String docNo;

    @Column(name = "state", columnDefinition = "varchar(32) comment '状态'")
    private String state;

    @Column(name = "type", columnDefinition = "varchar(32) comment '单据类型'")
    private String type;

    @Column(name = "cg_type", columnDefinition = "varchar(32) comment '充值类型'")
    private String cgType;

    @Column(name = "acc_type", columnDefinition = "varchar(32) comment '账户类型'")
    private String accType;

    @Column(name = "rec_bank_name", columnDefinition = "varchar(32) comment '收款银行名称'")
    private String recBankName;

    @Column(name = "rec_bank_acc", columnDefinition = "varchar(32) comment '收款银行账户'")
    private String recBankAcc;

    @Column(name = "rec_type", columnDefinition = "varchar(32) comment '收款方式'")
    private String recType;

    @Column(name = "pay_open_bank", columnDefinition = "varchar(32) comment '汇款开户行'")
    private String payOpenBank;

    @Column(name = "pay_bank_acc", columnDefinition = "varchar(32) comment '汇款银行账户'")
    private String payBankAcc;

    @Column(name = "cg_time", columnDefinition = "datetime(6) comment '汇款时间'")
    private LocalDateTime cgTime;

    @Column(name = "acc_name", columnDefinition = "varchar(32) comment '账户名称'")
    private String accName;

    @Column(name = "acc_code", columnDefinition = "varchar(32) comment '账户编码'")
    private String accCode;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) DEFAULT 0 comment '总金额'")
    private BigDecimal totalAmt;

    @Column(name = "audit_user", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人id'")
    private Long auditUserId;

    @Column(name = "audit_time", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditTime;

    @Column(name = "audit_reject_reason", columnDefinition = "varchar(128) comment '审核拒绝理由'")
    private String auditRejectReason;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司id'")
    private Long ouId;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源id'")
    private Long sourceId;

    @Column(name = "del_web",columnDefinition = "tinyint(1) default 0 comment '是否逻辑删除'")
    private Boolean delWeb;

    @Column(name = "refund_amt", columnDefinition = "decimal(18,8) DEFAULT 0 comment '已退款金额'")
    private BigDecimal refundAmt;

    @Column(name = "unrefund_amt", columnDefinition = "decimal(18,8) DEFAULT 0 comment '未退款金额'")
    private BigDecimal unrefundAmt;
}